/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.table.DefaultTableConfiguration;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTableColumn;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.misc.FormatHelper;
import org.tentackle.reflect.ReflectionHelper;

public class DefaultTableColumnConfiguration<S, T>
implements TableColumnConfiguration<S, T> {
    private final DefaultTableConfiguration<S> tableConfiguration;
    private final String name;
    private String displayedName;
    private FxTableColumn<S, T> tableColumn;
    private FxTableBinding<S, T> binding;
    private Class<T> type;
    private Type genericType;
    private String pattern;
    private DecimalFormat numberFormat;
    private DateFormat dateFormat;
    private DateTimeFormatter dateTimeFormatter;
    private Pos alignment;
    private Boolean blankZero;
    private Boolean unsigned;
    private String validChars;
    private String invalidChars;
    private Boolean autoSelect;
    private Integer maxColumns;
    private Integer scale;
    private Boolean caseConversion;
    private Boolean summable;
    private Boolean editable;
    private FxComponent editor;

    public DefaultTableColumnConfiguration(DefaultTableConfiguration<S> tableConfiguration, String name, String displayedName) {
        this.tableConfiguration = tableConfiguration;
        this.name = name;
        this.displayedName = displayedName;
    }

    public String toString() {
        return this.tableConfiguration.getName() + "." + this.name;
    }

    @Override
    public DefaultTableConfiguration<S> getTableConfiguration() {
        return this.tableConfiguration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayedName() {
        return this.displayedName;
    }

    @Override
    public void setDisplayedName(String displayedName) {
        this.displayedName = displayedName;
        if (this.tableColumn != null) {
            this.tableColumn.setText(displayedName);
        }
    }

    @Override
    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.numberFormat = null;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public DecimalFormat getNumberFormat() {
        if (this.numberFormat == null && (this.pattern != null || this.scale != null)) {
            if (this.pattern == null) {
                this.pattern = FormatHelper.getIntegerPattern();
            }
            this.numberFormat = new DecimalFormat(this.pattern);
            if (this.scale == null) {
                this.scale = 0;
                String p = this.getPattern();
                int dotNdx = p.lastIndexOf(46);
                if (dotNdx >= 0) {
                    ++dotNdx;
                    while (dotNdx < p.length() && p.charAt(dotNdx) == '0') {
                        Integer n = this.scale;
                        Integer n2 = this.scale = Integer.valueOf(this.scale + 1);
                        ++dotNdx;
                    }
                }
            } else {
                FormatHelper.setScale((DecimalFormat)this.numberFormat, (int)this.scale);
            }
        }
        return this.numberFormat;
    }

    @Override
    public DateFormat getDateFormat() {
        if (this.dateFormat == null && this.pattern != null) {
            this.dateFormat = new SimpleDateFormat(this.pattern);
        }
        return this.dateFormat;
    }

    @Override
    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null && this.pattern != null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern);
        }
        return this.dateTimeFormatter;
    }

    @Override
    public void setAlignment(Pos alignment) {
        this.alignment = alignment;
    }

    @Override
    public Pos getAlignment() {
        return this.alignment;
    }

    @Override
    public void setBlankZero(Boolean blankZero) {
        this.blankZero = blankZero;
    }

    @Override
    public Boolean isBlankZero() {
        return this.blankZero;
    }

    @Override
    public Boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public void setUnsigned(Boolean unsigned) {
        this.unsigned = unsigned;
    }

    @Override
    public String getValidChars() {
        return this.validChars;
    }

    @Override
    public void setValidChars(String validChars) {
        this.validChars = validChars;
    }

    @Override
    public String getInvalidChars() {
        return this.invalidChars;
    }

    @Override
    public void setInvalidChars(String invalidChars) {
        this.invalidChars = invalidChars;
    }

    @Override
    public void setAutoSelect(Boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    @Override
    public Boolean isAutoSelect() {
        return this.autoSelect;
    }

    @Override
    public void setMaxColumns(Integer maxColumns) {
        this.maxColumns = maxColumns;
    }

    @Override
    public Integer getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
        this.numberFormat = null;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setCaseConversion(Boolean caseConversion) {
        this.caseConversion = caseConversion;
    }

    @Override
    public Boolean getCaseConversion() {
        return this.caseConversion;
    }

    @Override
    public boolean isSummable() {
        if (this.summable != null) {
            return this.summable;
        }
        return this.type != null && Number.class.isAssignableFrom(this.type.isPrimitive() ? ReflectionHelper.primitiveToWrapperClass(this.type) : this.type);
    }

    @Override
    public void setSummable(Boolean summable) {
        this.summable = summable;
    }

    @Override
    public Boolean getSummable() {
        return this.summable;
    }

    @Override
    public boolean isEditable() {
        return Boolean.TRUE.equals(this.editable) || this.tableConfiguration != null && this.tableConfiguration.getEditMode() != TableConfiguration.EDITMODE.NO;
    }

    @Override
    public Boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    @Override
    public FxComponent getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(FxComponent editor) {
        this.editor = editor;
    }

    @Override
    public void setBinding(FxTableBinding<S, T> binding) {
        this.binding = binding;
    }

    @Override
    public FxTableBinding<S, T> getBinding() {
        return this.binding;
    }

    @Override
    public FxTableColumn<S, T> getTableColumn() {
        if (this.tableColumn == null) {
            this.tableColumn = this.createTableColumn();
        }
        return this.tableColumn;
    }

    protected ObservableValue<T> createCellValue(TableColumn.CellDataFeatures<S, T> cdf) {
        if (this.binding == null) {
            throw new FxRuntimeException("missing binding for " + this);
        }
        this.binding.setBoundRootObject(cdf.getValue());
        return new ReadOnlyObjectWrapper(this.binding.getModelValue());
    }

    protected Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> createCellValueFactory() {
        return this::createCellValue;
    }

    protected TableCell<S, T> createTableCell(TableColumn<S, T> column) {
        return new FxTableCell(this);
    }

    protected Callback<TableColumn<S, T>, TableCell<S, T>> createCellFactory() {
        return this::createTableCell;
    }

    protected FxTableColumn<S, T> createTableColumn() {
        FxTableColumn tc = new FxTableColumn(this, this.displayedName);
        tc.setCellValueFactory(this.createCellValueFactory());
        tc.setCellFactory(this.createCellFactory());
        return tc;
    }
}

