/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.tentackle.bind.BindableElement;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderService;
import org.tentackle.reflect.ReflectionHelper;

public class DefaultTableConfigurationProvider<T>
implements TableConfigurationProvider<T> {
    private final Class<T> clazz;
    private final boolean bundleProvided;
    private final TableConfiguration.BINDING bindingType;
    private ResourceBundle bundle;

    public DefaultTableConfigurationProvider() {
        TableConfigurationProviderService annotation = this.getClass().getAnnotation(TableConfigurationProviderService.class);
        if (annotation == null) {
            if (this.getClass() != DefaultTableConfigurationProvider.class) {
                throw new FxRuntimeException(this.getClass() + " is not annotated with @" + ReflectionHelper.getClassBaseName(TableConfigurationProviderService.class));
            }
            this.clazz = Object.class;
            this.bundleProvided = false;
            this.bindingType = TableConfiguration.BINDING.NO;
        } else {
            this.clazz = annotation.value();
            this.bundleProvided = !annotation.noBundle();
            this.bindingType = annotation.binding();
        }
    }

    public boolean isBundleProvided() {
        return this.bundleProvided;
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = BundleFactory.getBundle((String)this.getClass().getName());
        }
        return this.bundle;
    }

    @Override
    public TableConfiguration<T> createTableConfiguration() {
        TableConfiguration<T> configuration = FxFactory.getInstance().createTableConfiguration(this.clazz, (String)null);
        this.addBindableColumns(configuration, new String[0]);
        if (this.bindingType != null) {
            configuration.setBindingType(this.bindingType);
        }
        return configuration;
    }

    protected void addBindableColumns(TableConfiguration<T> configuration, String ... components) {
        this.addBindableColumns(configuration, "", "", this.clazz, components);
        Collection<TableColumnConfiguration<T, ?>> columnConfigurations = configuration.getColumnConfigurations();
        for (TableColumnConfiguration<T, ?> column : columnConfigurations) {
            String shortName;
            int ndx;
            String displayedName = column.getDisplayedName();
            if (displayedName == null || (ndx = displayedName.lastIndexOf(46)) < 0 || StringHelper.isAllWhitespace((String)(shortName = displayedName.substring(ndx + 1)))) continue;
            boolean shorten = true;
            for (TableColumnConfiguration<T, ?> otherColumn : columnConfigurations) {
                String otherName;
                if (otherColumn == column || !displayedName.equals(otherName = otherColumn.getDisplayedName()) && !shortName.equals(otherName)) continue;
                shorten = false;
                break;
            }
            if (!shorten) continue;
            column.setDisplayedName(shortName);
        }
    }

    protected void addBindableColumns(TableConfiguration<T> configuration, String columnPrefix, String displayPrefix, Class<?> clazz, String ... components) {
        if (this.bindingType != null && this.bindingType != TableConfiguration.BINDING.NO) {
            for (Map.Entry entry : FxBindingFactory.getInstance().getBindableCache().getBindableMap(clazz, this.bindingType == TableConfiguration.BINDING.YES).entrySet()) {
                String bindName = (String)entry.getKey();
                BindableElement element = (BindableElement)entry.getValue();
                String columnName = columnPrefix + StringHelper.firstToLower((String)bindName);
                String displayName = displayPrefix + (this.isBundleProvided() ? this.getBundle().getString(bindName) : bindName);
                boolean isComponent = false;
                if (components != null) {
                    for (String component : components) {
                        if (!columnName.equals(component)) continue;
                        isComponent = true;
                        break;
                    }
                }
                if (isComponent) {
                    this.addBindableColumns(configuration, columnName + ".", displayName + ".", element.getType(), new String[0]);
                    continue;
                }
                configuration.addColumn(columnName, displayName);
            }
        }
    }
}

