/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.table.DefaultTableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderFactory;
import org.tentackle.reflect.ClassMapper;

@Service(value=TableConfigurationProviderFactory.class)
public class DefaultTableConfigurationProviderFactory
implements TableConfigurationProviderFactory {
    private final ConcurrentHashMap<Class, TableConfigurationProvider> serviceMap = new ConcurrentHashMap();
    private final ClassMapper classMapper = ClassMapper.create((String)"FX table-config-provider", TableConfigurationProvider.class);
    private final TableConfigurationProvider noProvider = new DefaultTableConfigurationProvider();

    @Override
    public <T> TableConfigurationProvider<T> createTableConfigurationProvider(Class<T> clazz) {
        TableConfigurationProvider provider = this.serviceMap.get(clazz);
        if (provider == null) {
            try {
                Class serviceClass = this.classMapper.mapLenient(clazz);
                for (Constructor<?> con : serviceClass.getConstructors()) {
                    if (con.getParameterTypes().length != 0) continue;
                    provider = (TableConfigurationProvider)con.newInstance(new Object[0]);
                    break;
                }
                if (provider == null) {
                    throw new FxRuntimeException("no default constructor found for " + serviceClass.getName());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new FxRuntimeException("cannot instantiate table configuration service object for " + clazz.getName(), e);
            }
            catch (ClassNotFoundException ex) {
                provider = this.noProvider;
            }
            this.serviceMap.put(clazz, provider);
        }
        return provider == this.noProvider ? null : provider;
    }
}

