/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;
import org.tentackle.misc.FormatHelper;

@TableCellTypeService(value=LocalDate.class)
public class LocalDateTableCellType
extends AbstractTableCellType<LocalDate> {
    @Override
    public void updateItem(FxTableCell<?, LocalDate> tableCell, LocalDate item) {
        tableCell.setGraphic(null);
        DateTimeFormatter fmt = tableCell.getColumnConfiguration().getDateTimeFormatter();
        if (fmt == null) {
            fmt = FormatHelper.getLocalDateFormatter();
        }
        String text = fmt.format(item);
        tableCell.setText(text);
        this.updateAlignment(tableCell, Pos.CENTER);
    }
}

