/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.GregorianCalendar;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import org.tentackle.common.Date;
import org.tentackle.common.DateHelper;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.log.Logger;
import org.tentackle.misc.FormatHelper;

@ValueTranslatorService(modelClass=java.util.Date.class, viewClass=String.class)
public class DateStringTranslator
extends ValueStringTranslator<java.util.Date> {
    public static final String REFERENCE_DATE_SUPPLIER = "referenceDateSupplier";
    private static final Logger LOGGER = Logger.get(DateStringTranslator.class);
    public static Logger.Level informationLossLogLevel = Logger.Level.INFO;
    private static final String LEGACY_DATE_DELIMITERS = ".,/*=-";
    private static final String LEGACY_TIME_DELIMITERS = ":;\"'";
    private String pattern;
    private String dateDelimiters;
    private SimpleDateFormat format;
    private java.util.Date lastDate;

    public DateStringTranslator(FxTextComponent component) {
        super(component);
    }

    @Override
    public Function<java.util.Date, String> toViewFunction() {
        return this::format;
    }

    @Override
    public Function<String, java.util.Date> toModelFunction() {
        return s -> this.toType(this.parse((String)s));
    }

    protected String format(java.util.Date value) {
        this.lastDate = value;
        if (value != null) {
            boolean infoLoss = false;
            if (value instanceof Timestamp || value instanceof Time) {
                if (!FormatHelper.isFormattingTime((SimpleDateFormat)this.getFormat())) {
                    infoLoss = true;
                }
            } else if (!FormatHelper.isFormattingDate((SimpleDateFormat)this.getFormat())) {
                infoLoss = true;
            }
            if (infoLoss && informationLossLogLevel != null && informationLossLogLevel != Logger.Level.SEVERE && LOGGER.isLoggable(informationLossLogLevel)) {
                String msg = "possible information loss while formatting " + value.getClass().getName() + " '" + value + "' with format " + this.getFormat().toPattern() + " in:\n" + FxUtilities.getInstance().dumpComponentHierarchy((Node)this.getComponent());
                FxRuntimeException uix = informationLossLogLevel == Logger.Level.FINE || informationLossLogLevel == Logger.Level.FINER ? new FxRuntimeException(msg) : null;
                LOGGER.log(informationLossLogLevel, (String)(uix == null ? msg : ""), (Throwable)((Object)uix));
                if (informationLossLogLevel == Logger.Level.FINER && uix != null) {
                    throw uix;
                }
            }
            return this.getFormat().format(value);
        }
        return null;
    }

    protected java.util.Date toType(java.util.Date date) {
        if (date != null) {
            Class<?> type = this.getComponent().getType();
            if (org.tentackle.common.Timestamp.class.isAssignableFrom(type)) {
                org.tentackle.common.Timestamp ts = new org.tentackle.common.Timestamp(date.getTime());
                if (this.getComponent().isUTC()) {
                    ts.setUTC(true);
                }
                return ts;
            }
            if (org.tentackle.common.Time.class.isAssignableFrom(type)) {
                return new org.tentackle.common.Time(date.getTime());
            }
            if (Date.class.isAssignableFrom(type)) {
                return new Date(date.getTime());
            }
            if (Timestamp.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type)) {
                return new Timestamp(date.getTime());
            }
            if (Time.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type)) {
                return new Time(date.getTime());
            }
            if (java.sql.Date.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type)) {
                return new java.sql.Date(date.getTime());
            }
        }
        return date;
    }

    protected java.util.Date parse(String str) {
        if (str != null) {
            java.util.Date referenceDate = null;
            for (int loop = 0; loop < 3; ++loop) {
                this.getComponent().setError(null);
                str = ((String)str).replace(this.getComponent().getFiller(), ' ').trim();
                int slen = ((String)str).length();
                if (slen == 0) {
                    return null;
                }
                if (((String)str).charAt(0) == '@') {
                    str = ((String)str).substring(1, slen);
                    --slen;
                    Supplier dateSupplier = (Supplier)((Node)this.getComponent()).getProperties().get((Object)REFERENCE_DATE_SUPPLIER);
                    if (dateSupplier != null) {
                        Object refDate = dateSupplier.get();
                        if (refDate instanceof java.util.Date) {
                            referenceDate = (java.util.Date)refDate;
                        } else if (refDate instanceof LocalDate) {
                            referenceDate = java.sql.Date.valueOf((LocalDate)refDate);
                        } else if (refDate instanceof LocalTime) {
                            referenceDate = Time.valueOf((LocalTime)refDate);
                        } else if (refDate instanceof LocalDateTime) {
                            referenceDate = Timestamp.valueOf((LocalDateTime)refDate);
                        }
                        if (slen == 0) {
                            str = "+0";
                            slen = 2;
                        }
                    } else {
                        referenceDate = null;
                    }
                }
                if (((String)str).charAt(0) == '$') {
                    str = ((String)str).substring(1, slen);
                    --slen;
                    referenceDate = this.lastDate;
                }
                this.getFormat();
                boolean withDate = FormatHelper.isFormattingDate((SimpleDateFormat)this.format);
                boolean withTime = FormatHelper.isFormattingTime((SimpleDateFormat)this.format);
                if (slen == 1) {
                    char c = ((String)str).charAt(0);
                    if (withDate && LEGACY_DATE_DELIMITERS.indexOf(c) >= 0) {
                        GregorianCalendar cal = new GregorianCalendar();
                        DateHelper.setMidnight((GregorianCalendar)cal);
                        return this.parse(this.format(this.toType(cal.getTime())));
                    }
                    if (withTime && LEGACY_TIME_DELIMITERS.indexOf(c) >= 0) {
                        return this.parse(this.format(this.toType(new java.util.Date())));
                    }
                }
                if (slen > 0 && (((String)str).indexOf(45) == 0 || ((String)str).indexOf(43) == 0 || slen <= 2 && StringHelper.isAllDigits((String)str) || "sSmMhHdDwWyY".indexOf(((String)str).charAt(slen - 1)) >= 0)) {
                    boolean setValue = Character.isDigit(((String)str).charAt(0));
                    try {
                        int value;
                        int type;
                        GregorianCalendar cal = new GregorianCalendar();
                        if (referenceDate != null) {
                            cal.setTime(referenceDate);
                        }
                        if (Character.isDigit((char)(type = ((String)str).charAt(slen - 1)))) {
                            type = Time.class.isAssignableFrom(this.getComponent().getType()) || LocalTime.class.isAssignableFrom(this.getComponent().getType()) ? (this.pattern.indexOf(72) >= 0 || this.pattern.indexOf(104) >= 0 ? 104 : (this.pattern.indexOf(109) >= 0 ? 109 : (this.pattern.indexOf(115) >= 0 ? 115 : 104))) : 100;
                            value = Integer.parseInt((String)(((String)str).charAt(0) == '+' ? ((String)str).substring(1) : str));
                        } else {
                            value = Integer.parseInt(((String)str).substring(((String)str).charAt(0) == '+' ? 1 : 0, slen - 1));
                        }
                        if (setValue) {
                            switch (type) {
                                case 83: 
                                case 115: {
                                    this.setGregorianValue(cal, 13, value);
                                    break;
                                }
                                case 109: {
                                    if (this.pattern.indexOf(109) == -1) {
                                        this.setGregorianValue(cal, 2, value - 1);
                                        break;
                                    }
                                    this.setGregorianValue(cal, 12, value);
                                    cal.set(13, 0);
                                    break;
                                }
                                case 72: 
                                case 104: {
                                    this.setGregorianValue(cal, 11, value);
                                    cal.set(12, 0);
                                    cal.set(13, 0);
                                    break;
                                }
                                case 68: 
                                case 100: {
                                    this.setGregorianValue(cal, 5, value);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 87: 
                                case 119: {
                                    this.setGregorianValue(cal, 3, value);
                                    cal.set(7, cal.getFirstDayOfWeek());
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 77: {
                                    this.setGregorianValue(cal, 2, value - 1);
                                    cal.set(5, 1);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 89: 
                                case 121: {
                                    if (value < 100) {
                                        value = this.convert2DigitYearTo4DigitYear(value);
                                    }
                                    this.setGregorianValue(cal, 1, value);
                                    cal.set(6, 1);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                }
                            }
                        } else {
                            switch (type) {
                                case 83: 
                                case 115: {
                                    cal.add(13, value);
                                    break;
                                }
                                case 109: {
                                    if (this.pattern.indexOf(109) == -1) {
                                        cal.add(2, value);
                                        break;
                                    }
                                    cal.add(12, value);
                                    break;
                                }
                                case 72: 
                                case 104: {
                                    cal.add(10, value);
                                    break;
                                }
                                case 68: 
                                case 100: {
                                    cal.add(5, value);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 87: 
                                case 119: {
                                    cal.add(3, value);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 77: {
                                    cal.add(2, value);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                    break;
                                }
                                case 89: 
                                case 121: {
                                    cal.add(1, value);
                                    DateHelper.setMidnight((GregorianCalendar)cal);
                                }
                            }
                        }
                        return this.parse(this.format(this.toType(cal.getTime())));
                    }
                    catch (ParseException e) {
                        this.getComponent().setErrorOffset(e.getErrorOffset());
                        this.getComponent().setError(e.getMessage());
                        this.getComponent().setErrorTemporary(true);
                        return null;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                try {
                    int year;
                    java.util.Date date = this.format.parse((String)str);
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    if (!withTime) {
                        DateHelper.setMidnight((GregorianCalendar)cal);
                        date = cal.getTime();
                    }
                    if ((year = cal.get(1)) < 100) {
                        year = this.convert2DigitYearTo4DigitYear(year);
                        cal.set(1, year);
                        date = cal.getTime();
                    }
                    return date;
                }
                catch (ParseException e) {
                    char c;
                    int spos;
                    this.getComponent().setErrorOffset(e.getErrorOffset());
                    this.getComponent().setError(MessageFormat.format(FxFxBundle.getString(withDate ? "INVALID DATE: {0}" : "INVALID TIME: {0}"), str));
                    this.getComponent().setErrorTemporary(true);
                    char errorChar = '\u0000';
                    if (e.getErrorOffset() > 0 && e.getErrorOffset() == slen) {
                        errorChar = ((String)str).charAt(e.getErrorOffset() - 1);
                    }
                    if (errorChar > '\u0000' && this.dateDelimiters.indexOf(errorChar) >= 0) {
                        str = (String)str + new GregorianCalendar().get(1);
                        continue;
                    }
                    if (errorChar == ':') {
                        str = (String)str + "00";
                        continue;
                    }
                    if (slen > 2 && Character.isDigit(errorChar) && Character.isDigit(((String)str).charAt(slen - 2)) && (((String)str).charAt(slen - 3) == ':' || ((String)str).charAt(slen - 3) == ' ') || slen > 1 && Character.isDigit(errorChar) && (((String)str).charAt(slen - 2) == ':' || ((String)str).charAt(slen - 2) == ' ')) {
                        str = (String)str + ":00";
                        continue;
                    }
                    StringBuilder nBuf = new StringBuilder();
                    int dlen = this.dateDelimiters.length();
                    int dpos = 0;
                    for (spos = 0; spos < slen && this.dateDelimiters.indexOf(c = ((String)str).charAt(spos)) < 0 && LEGACY_DATE_DELIMITERS.indexOf(c) < 0; ++spos) {
                        if (dpos < dlen && spos > 0 && spos % 2 == 0) {
                            nBuf.append(this.dateDelimiters.charAt(dpos++));
                        }
                        nBuf.append(c);
                    }
                    if (spos == slen) {
                        if (slen % 2 == 0 && dpos < dlen) {
                            nBuf.append(this.dateDelimiters.charAt(dpos));
                        }
                        if (nBuf.length() == 6) {
                            nBuf.append(new GregorianCalendar().get(1));
                        }
                        str = nBuf.toString();
                        continue;
                    }
                    boolean timeOnly = true;
                    int colonCount = 0;
                    for (int i = 0; i < slen; ++i) {
                        char c2 = ((String)str).charAt(i);
                        if (c2 == ':') {
                            ++colonCount;
                            continue;
                        }
                        if (Character.isDigit(c2)) continue;
                        timeOnly = false;
                        break;
                    }
                    if (timeOnly) {
                        try {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime((java.util.Date)(colonCount == 1 ? FormatHelper.parseShortTime((String)str) : FormatHelper.parseTime((String)str)));
                            int hour = cal.get(11);
                            int minute = cal.get(12);
                            int second = cal.get(13);
                            cal.setTime(new java.util.Date());
                            cal.set(11, hour);
                            cal.set(12, minute);
                            cal.set(13, second);
                            this.getComponent().setError(null);
                            return cal.getTime();
                        }
                        catch (ParseException cal) {
                            continue;
                        }
                    }
                    Object newstr = (String)str + " 00:00:00";
                    try {
                        this.format.parse((String)newstr);
                        str = newstr;
                    }
                    catch (ParseException ex) {
                        if (this.dateDelimiters.length() <= 0) continue;
                        StringBuilder buf = new StringBuilder((String)str);
                        String delimStr = this.dateDelimiters.substring(0, 1);
                        for (int i = 0; i < buf.length(); ++i) {
                            char c3 = buf.charAt(i);
                            if (LEGACY_DATE_DELIMITERS.indexOf(c3) < 0) continue;
                            buf.replace(i, i + 1, delimStr);
                        }
                        newstr = buf.toString();
                        if (((String)newstr).equals(str)) continue;
                        try {
                            this.format.parse((String)newstr);
                            str = newstr;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
        }
        return null;
    }

    protected String getDefaultPattern() {
        Class<?> type = this.getComponent().getType();
        String pat = Time.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type) ? FormatHelper.getTimePattern() : (Timestamp.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type) ? FormatHelper.getTimestampPattern() : FormatHelper.getDatePattern());
        return pat;
    }

    protected SimpleDateFormat getFormat() {
        String pat = this.getComponent().getPattern();
        if (pat == null) {
            pat = this.getDefaultPattern();
        }
        if (this.format == null || !pat.equals(this.pattern)) {
            this.pattern = pat;
            this.format = new SimpleDateFormat(this.pattern);
            this.format.setLenient(this.getComponent().isLenient());
        }
        StringBuilder buf = new StringBuilder();
        String f = this.format.toPattern();
        for (int i = 0; i < f.length(); ++i) {
            char c = f.charAt(i);
            if (c == ':' || Character.isLetterOrDigit(c)) continue;
            buf.append(c);
        }
        this.dateDelimiters = buf.toString();
        return this.format;
    }

    protected void setGregorianValue(GregorianCalendar cal, int field, int value) throws ParseException {
        int min = cal.getActualMinimum(field);
        int max = cal.getActualMaximum(field);
        if (value < min || value > max) {
            if (field == 2) {
                ++value;
                ++min;
                ++max;
            }
            throw new ParseException(MessageFormat.format(FxFxBundle.getString("INVALID {0}: {1} MUST BE BETWEEN {2} AND {3}"), FormatHelper.calendarFieldToString((int)field, (boolean)false), value, min, max), 0);
        }
        cal.set(field, value);
    }

    protected int convert2DigitYearTo4DigitYear(int year2) {
        return DateHelper.convert2DigitYearTo4DigitYear((int)year2, (int)new GregorianCalendar().get(1));
    }
}

