/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.Function;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.DateStringTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=LocalDateTime.class, viewClass=String.class)
public class LocalDateTimeStringConverter
extends ValueStringTranslator<LocalDateTime> {
    private final DateStringTranslator translator;

    public LocalDateTimeStringConverter(FxTextComponent component) {
        super(component);
        this.translator = new DateStringTranslator(component);
    }

    @Override
    public Function<LocalDateTime, String> toViewFunction() {
        return v -> this.translator.format(v == null ? null : Timestamp.valueOf(v));
    }

    @Override
    public Function<String, LocalDateTime> toModelFunction() {
        return s -> {
            Date date = this.translator.parse((String)s);
            return date == null ? null : new Timestamp(date.getTime()).toLocalDateTime();
        };
    }
}

