/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.sql.Time;
import java.time.LocalTime;
import java.util.Date;
import java.util.function.Function;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.DateStringTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=LocalTime.class, viewClass=String.class)
public class LocalTimeStringConverter
extends ValueStringTranslator<LocalTime> {
    private final DateStringTranslator translator;

    public LocalTimeStringConverter(FxTextComponent component) {
        super(component);
        this.translator = new DateStringTranslator(component);
    }

    @Override
    public Function<LocalTime, String> toViewFunction() {
        return v -> this.translator.format(v == null ? null : Time.valueOf(v));
    }

    @Override
    public Function<String, LocalTime> toModelFunction() {
        return s -> {
            Date date = this.translator.parse((String)s);
            return date == null ? null : new Time(date.getTime()).toLocalTime();
        };
    }
}

