/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.misc.FormatHelper;

public abstract class NumberStringTranslator<M extends Number>
extends ValueStringTranslator<M> {
    private String pattern;
    private DecimalFormat format;

    public NumberStringTranslator(FxTextComponent component) {
        super(component);
    }

    protected Number parse(String s) {
        if (s != null) {
            try {
                return this.getFormat().parse(s);
            }
            catch (ParseException pex) {
                this.getComponent().setErrorOffset(pex.getErrorOffset());
                this.getComponent().setError(MessageFormat.format(FxFxBundle.getString("INVALID NUMBER: {0}"), s));
                this.getComponent().setErrorTemporary(true);
                throw new FxRuntimeException("conversion failed for '" + s + "'", pex);
            }
        }
        return null;
    }

    @Override
    public String getValidChars() {
        return this.getComponent().isUnsigned() ? ".,0123456789" : ".,-0123456789";
    }

    public abstract String getDefaultPattern();

    protected DecimalFormat getFormat() {
        String pat = this.getComponent().getPattern();
        if (pat == null) {
            pat = this.getDefaultPattern();
        }
        if (this.format == null || !pat.equals(this.pattern)) {
            this.pattern = pat;
            this.format = new DecimalFormat(this.pattern);
            FormatHelper.setScale((DecimalFormat)this.format, (int)this.getComponent().getScale());
        }
        return this.format;
    }
}

