/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.control.Label;
import javafx.util.Builder;
import org.tentackle.fx.Configurator;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxPropertyMapping;
import org.tentackle.reflect.PropertyMap;
import org.tentackle.reflect.PropertyMapping;

public class AbstractBuilder<T>
extends PropertyMap<T>
implements Builder<T> {
    private static final Label DUMMY_LABEL = new Label();
    private final Set<String> innerElements;

    public AbstractBuilder(T bean) {
        super(bean);
        this.innerElements = null;
    }

    public AbstractBuilder(T bean, String ... innerElements) {
        super(bean);
        this.innerElements = innerElements == null ? null : new HashSet<String>(Arrays.asList(innerElements));
    }

    public Object get(Object key) {
        Object object = super.get(key);
        if (object == null && this.innerElements != null && this.innerElements.contains(key)) {
            object = DUMMY_LABEL;
        }
        return object;
    }

    public T build() {
        Object bean = this.getBean();
        Configurator<Object> configurator = FxFactory.getInstance().getConfigurator(this.getBeanType());
        if (configurator != null) {
            configurator.configure(bean);
        }
        return (T)bean;
    }

    protected PropertyMapping<T> createMapping(String name, Method getter, Method setter) {
        return new FxPropertyMapping(name, getter, setter);
    }
}

