/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.tentackle.log.Logger;

public class BundleMonkeyHelper {
    public static final String SOCKET_NAME = ".bmonkey.sock";
    public static final String BUNDLENAME_PREFIX = "${";
    public static final String BUNDLENAME_POSTFIX = "}$";
    public static final String LOCALE_PREFIX = "(LOCALE=";
    public static final String LOCALE_POSTFIX = ")";
    private static final Logger LOGGER = Logger.get(BundleMonkeyHelper.class);

    public static Path createSocketPath() {
        return Path.of(System.getProperty("user.home"), new String[0]).resolve(SOCKET_NAME);
    }

    public static String createNavigationString(String bundleName) {
        return BUNDLENAME_PREFIX + bundleName + BUNDLENAME_POSTFIX;
    }

    public static void navigateTo(String hierarchyDump) {
        try (SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);){
            channel.connect(UnixDomainSocketAddress.of(BundleMonkeyHelper.createSocketPath()));
            byte[] bytes = hierarchyDump.getBytes(StandardCharsets.UTF_8);
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.clear();
            buf.put(bytes);
            buf.flip();
            while (buf.hasRemaining()) {
                channel.write(buf);
            }
            LOGGER.fine("component hierarchy dump sent to BundleMonkey");
        }
        catch (IOException iox) {
            LOGGER.fine("BundleMonkey not listening");
        }
    }

    private BundleMonkeyHelper() {
    }
}

