/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import javafx.scene.Node;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.InteractiveError;
import org.tentackle.validate.ValidationResult;

public class DefaultInteractiveError
implements InteractiveError {
    private final boolean warning;
    private final String text;
    private final String errorCode;
    private final ValidationResult validationResult;
    private final FxControl control;

    public DefaultInteractiveError(boolean warning, String text, String errorCode, ValidationResult validationResult, FxControl control) {
        this.warning = warning;
        this.text = text;
        this.errorCode = errorCode;
        this.validationResult = validationResult;
        this.control = control;
    }

    public DefaultInteractiveError(ValidationResult validationResult, FxControl control) {
        this(!validationResult.hasFailed(), validationResult.getMessage(), validationResult.getErrorCode(), validationResult, control);
    }

    public DefaultInteractiveError(InteractiveError error) {
        this(error.isWarning(), error.getText(), error.getErrorCode(), error.getValidationResult(), error.getControl());
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public boolean isWarning() {
        return this.warning;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public FxControl getControl() {
        return this.control;
    }

    @Override
    public void showControl() {
        if (this.control instanceof Node) {
            ((Node)this.control).requestFocus();
        }
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }
}

