/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.kordamp.ikonli.javafx.FontIcon;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.NotificationBuilder;

public class DefaultNotificationBuilder
implements NotificationBuilder {
    private NotificationBuilder.Type type = NotificationBuilder.Type.NONE;
    private Node graphic;
    private String title;
    private String text;
    private String details;
    private Node content;
    private Duration duration;
    private Duration fadeOut;
    private Duration fadeIn;
    private final List<ButtonConfig> buttonConfigs = new ArrayList<ButtonConfig>();
    private ButtonConfig defaultButtonConfig;
    private Runnable hide;
    private URL css;
    private NotificationBuilder.CloseButtonMode closeButtonMode = NotificationBuilder.CloseButtonMode.AUTO;

    @Override
    public NotificationBuilder type(NotificationBuilder.Type type) {
        this.type = type == null ? NotificationBuilder.Type.NONE : type;
        return this;
    }

    @Override
    public NotificationBuilder graphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    @Override
    public NotificationBuilder title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public NotificationBuilder text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public NotificationBuilder details(String details) {
        this.details = details;
        return this;
    }

    @Override
    public NotificationBuilder content(Node content) {
        this.content = content;
        return this;
    }

    @Override
    public NotificationBuilder duration(long duration) {
        this.duration = duration > 0L ? new Duration((double)duration) : null;
        return this;
    }

    @Override
    public NotificationBuilder fadeOut(long fadeOut) {
        this.fadeOut = fadeOut > 0L ? new Duration((double)fadeOut) : null;
        return this;
    }

    @Override
    public NotificationBuilder fadeIn(long fadeIn) {
        this.fadeIn = fadeIn > 0L ? new Duration((double)fadeIn) : null;
        return this;
    }

    @Override
    public NotificationBuilder button(String text, Node graphic, boolean isDefault, Runnable action) {
        ButtonConfig buttonConfig = new ButtonConfig(text, graphic, action);
        this.buttonConfigs.add(buttonConfig);
        if (isDefault) {
            this.defaultButtonConfig = buttonConfig;
        }
        return this;
    }

    @Override
    public NotificationBuilder hide(Runnable hide) {
        this.hide = hide;
        return this;
    }

    @Override
    public NotificationBuilder css(URL css) {
        this.css = css;
        return this;
    }

    @Override
    public NotificationBuilder closeButton(NotificationBuilder.CloseButtonMode closeButtonMode) {
        this.closeButtonMode = closeButtonMode == null ? NotificationBuilder.CloseButtonMode.AUTO : closeButtonMode;
        return this;
    }

    @Override
    public Parent build() {
        URL cssURL;
        BorderPane parent;
        BorderPane borderPane = new BorderPane();
        borderPane.setId("notificationPane");
        HBox headerBox = new HBox();
        headerBox.setId("headerBox");
        Node icon = this.getGraphic();
        if (icon != null) {
            if (this.type == NotificationBuilder.Type.WARNING) {
                icon.setId("warningIcon");
            } else if (this.type == NotificationBuilder.Type.ERROR) {
                icon.setId("errorIcon");
            } else {
                icon.setId("standardIcon");
            }
            headerBox.getChildren().add((Object)icon);
        }
        headerBox.getChildren().add((Object)new Label(this.text));
        borderPane.setTop((Node)headerBox);
        if (this.content != null) {
            borderPane.setCenter(this.content);
        } else if (this.details != null) {
            StackPane detailsStackPane = new StackPane();
            detailsStackPane.setAlignment(Pos.TOP_RIGHT);
            TextArea textArea = new TextArea(this.details);
            textArea.setEditable(false);
            detailsStackPane.getChildren().add((Object)textArea);
            Button copyButton = new Button("", Fx.createGraphic("copy"));
            copyButton.setId("copyButton");
            copyButton.setFocusTraversable(false);
            copyButton.setTooltip(new Tooltip(FxFxBundle.getString("COPY TO CLIPBOARD")));
            copyButton.setOnAction(event -> {
                ClipboardContent cbc = new ClipboardContent();
                cbc.putString(this.details);
                Clipboard.getSystemClipboard().setContent((Map)cbc);
            });
            detailsStackPane.getChildren().add((Object)copyButton);
            borderPane.setCenter((Node)detailsStackPane);
        }
        if (this.hide != null && this.closeButtonMode != NotificationBuilder.CloseButtonMode.NEVER && (this.buttonConfigs.isEmpty() || this.closeButtonMode.isAlwaysShown())) {
            StackPane borderStackPane = new StackPane();
            parent = borderStackPane;
            borderStackPane.setAlignment(Pos.TOP_RIGHT);
            borderStackPane.getChildren().add((Object)borderPane);
            Button closeButton = new Button("", Fx.createGraphic("close"));
            closeButton.setId("closeButton");
            closeButton.setFocusTraversable(false);
            if (this.closeButtonMode.isDefaultButton()) {
                closeButton.setDefaultButton(true);
            }
            closeButton.setTooltip(new Tooltip(FxFxBundle.getString("CLOSE")));
            closeButton.setOnAction(event -> this.hide.run());
            borderStackPane.getChildren().add((Object)closeButton);
        } else {
            parent = borderPane;
        }
        if (!this.buttonConfigs.isEmpty()) {
            HBox buttonBox = new HBox();
            buttonBox.setId("buttonBox");
            for (ButtonConfig buttonConfig : this.buttonConfigs) {
                Button button = new Button(buttonConfig.text(), buttonConfig.graphic());
                button.setOnAction(event -> {
                    if (buttonConfig.action() != null) {
                        buttonConfig.action().run();
                    }
                    if (this.hide != null) {
                        this.hide.run();
                    }
                });
                button.setFocusTraversable(false);
                if (buttonConfig == this.defaultButtonConfig) {
                    button.setDefaultButton(true);
                }
                buttonBox.getChildren().add((Object)button);
            }
            borderPane.setBottom((Node)buttonBox);
        }
        URL uRL = cssURL = this.css == null ? this.getDefaultCSS() : this.css;
        if (cssURL != null) {
            String stylesheetUrl = cssURL.toExternalForm();
            parent.getStylesheets().add(0, (Object)stylesheetUrl);
        }
        parent.getStyleClass().add((Object)"tt-notification");
        if (this.fadeIn != null || this.duration != null || this.fadeOut != null) {
            SequentialTransition transition = new SequentialTransition();
            if (this.fadeIn != null) {
                FadeTransition fadeInTransition = new FadeTransition(this.fadeIn, (Node)parent);
                fadeInTransition.setFromValue(0.0);
                fadeInTransition.setToValue(1.0);
                transition.getChildren().add((Object)fadeInTransition);
            }
            if (this.hide != null) {
                if (this.duration != null) {
                    transition.getChildren().add((Object)new PauseTransition(this.duration));
                }
                if (this.fadeOut != null) {
                    FadeTransition fadeOutTransition = new FadeTransition(this.fadeOut, (Node)parent);
                    fadeOutTransition.setFromValue(1.0);
                    fadeOutTransition.setToValue(0.0);
                    transition.getChildren().add((Object)fadeOutTransition);
                }
                transition.setOnFinished(event -> this.hide.run());
            }
            transition.play();
        }
        return parent;
    }

    @Override
    public String getTitle() {
        String string;
        if (this.title != null) {
            string = this.title;
        } else {
            switch (this.type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INFORMATION: {
                    string = FxFxBundle.getString("INFORMATION");
                    break;
                }
                case WARNING: {
                    string = FxFxBundle.getString("WARNING");
                    break;
                }
                case ERROR: {
                    string = FxFxBundle.getString("ERROR");
                    break;
                }
                case CONFIRMATION: {
                    string = FxFxBundle.getString("CONFIRMATION");
                    break;
                }
                case QUESTION: {
                    string = FxFxBundle.getString("QUESTION");
                    break;
                }
                case NONE: {
                    string = null;
                }
            }
        }
        return string;
    }

    protected URL getDefaultCSS() {
        return NotificationBuilder.class.getResource("notification.css");
    }

    private Node getGraphic() {
        Node node;
        if (this.graphic != null) {
            node = this.graphic;
        } else {
            switch (this.type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INFORMATION: {
                    node = new FontIcon("mdi2i-information-outline");
                    break;
                }
                case WARNING: {
                    node = new FontIcon("mdi2a-alert-circle-outline");
                    break;
                }
                case ERROR: {
                    node = new FontIcon("mdi2a-alert-outline");
                    break;
                }
                case CONFIRMATION: {
                    node = new FontIcon("mdi2c-check-circle-outline");
                    break;
                }
                case QUESTION: {
                    node = new FontIcon("mdi2c-comment-question-outline");
                    break;
                }
                case NONE: {
                    node = null;
                }
            }
        }
        return node;
    }

    private record ButtonConfig(String text, Node graphic, Runnable action) {
    }
}

