/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Builder;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;

public class Fx {
    public static <T> T load(URL location) throws IOException {
        FXMLLoader loader = new FXMLLoader(location, null, FxFactory.getInstance().getBuilderFactory());
        return (T)loader.load();
    }

    public static <T> T load(URL location, ResourceBundle resources) throws IOException {
        FXMLLoader loader = new FXMLLoader(location, resources, FxFactory.getInstance().getBuilderFactory());
        return (T)loader.load();
    }

    public static <T extends FxController> T load(Class<T> controllerClass) {
        return FxFactory.getInstance().createController(controllerClass, null, null, null);
    }

    public static Stage createStage(StageStyle stageStyle, Modality modality) {
        return FxFactory.getInstance().createStage(stageStyle, modality);
    }

    public static Stage createStage(Modality modality) {
        return Fx.createStage(StageStyle.DECORATED, modality);
    }

    public static Scene createScene(Parent root) {
        return FxFactory.getInstance().createScene(root);
    }

    public static <T, R extends T> R create(Class<T> clazz) {
        Builder builder = FxFactory.getInstance().getBuilderFactory().getBuilder(clazz);
        if (builder != null) {
            return (R)builder.build();
        }
        try {
            return (R)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FxRuntimeException("cannot create " + clazz.getName());
        }
    }

    public static void info(Object owner, String message, Runnable onClose) {
        FxUtilities.getInstance().showInfoDialog(owner, message, onClose);
    }

    public static void info(Object owner, String message) {
        Fx.info(owner, message, null);
    }

    public static void warning(Object owner, String message, Runnable onClose) {
        FxUtilities.getInstance().showWarningDialog(owner, message, onClose);
    }

    public static void warning(Object owner, String message) {
        Fx.warning(owner, message, null);
    }

    public static void error(Object owner, String message, Throwable t, Runnable onClose) {
        FxUtilities.getInstance().showErrorDialog(owner, message, t, onClose);
    }

    public static void error(Object owner, String message, Throwable t) {
        Fx.error(owner, message, t, null);
    }

    public static void error(Object owner, String message) {
        Fx.error(owner, message, null, null);
    }

    public static void question(Object owner, String message, boolean defaultYes, Consumer<Boolean> answer) {
        FxUtilities.getInstance().showQuestionDialog(owner, message, defaultYes, answer);
    }

    public static void yes(Object owner, String message, boolean defaultYes, Runnable yes) {
        FxUtilities.getInstance().showQuestionDialog(owner, message, defaultYes, answer -> {
            if (answer.booleanValue()) {
                yes.run();
            }
        });
    }

    public static void no(Object owner, String message, boolean defaultYes, Runnable no) {
        FxUtilities.getInstance().showQuestionDialog(owner, message, defaultYes, answer -> {
            if (!answer.booleanValue()) {
                no.run();
            }
        });
    }

    public static Node createGraphic(String realm, String name) {
        return FxFactory.getInstance().createGraphic(realm, name);
    }

    public static Node createGraphic(String name) {
        return Fx.createGraphic("", name);
    }

    public static Stage getStage(Node node) {
        return FxUtilities.getInstance().getStage(node);
    }

    public static boolean isModal(Stage stage) {
        return FxUtilities.getInstance().isModal(stage);
    }

    public static void terminate() {
        FxUtilities.getInstance().terminate();
    }

    private Fx() {
    }
}

