/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import org.tentackle.common.ServiceFactory;
import org.tentackle.fx.FxRuntimeException;

public class FxBuilderFactory
implements BuilderFactory {
    private final BuilderFactory defaultFactory = new JavaFXBuilderFactory();
    private final Map<Class<?>, Class<?>> builderMap;

    public FxBuilderFactory() {
        Map serviceMap = ServiceFactory.getServiceFinder().createNameMap(Builder.class.getName());
        this.builderMap = new HashMap();
        for (Map.Entry entry : serviceMap.entrySet()) {
            try {
                Class<?> nodeClass = Class.forName((String)entry.getKey());
                Class<?> builderClass = Class.forName((String)entry.getValue());
                this.builderMap.put(nodeClass, builderClass);
            }
            catch (ClassNotFoundException ex) {
                throw new FxRuntimeException(ex);
            }
        }
    }

    public Builder<?> getBuilder(Class<?> type) {
        Builder builder;
        Class<?> builderClass = this.builderMap.get(type);
        if (builderClass != null) {
            try {
                builder = (Builder)builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new FxRuntimeException("cannot create builder for " + type, ex);
            }
        } else {
            builder = this.defaultFactory.getBuilder(type);
        }
        return builder;
    }
}

