/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.ObjectUtilities;
import org.tentackle.reflect.PropertyMapping;

public class FxPropertyMapping<T>
extends PropertyMapping<T> {
    public FxPropertyMapping(String name, Method getter, Method setter) {
        super(name, getter, setter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(T object, Object value) {
        try {
            if (this.isReadOnly()) {
                if (!List.class.isAssignableFrom(this.getValueType())) throw new ImmutableException("property " + this + " is read-only");
                List list = (List)this.getGetter().invoke(object, new Object[0]);
                if (value instanceof List) {
                    List values = (List)value;
                    list.addAll(values);
                    return;
                } else {
                    if (value == null) throw new FxRuntimeException("setting list property " + this + " failed: value is null");
                    Collections.addAll(list, value.toString().split(","));
                }
                return;
            } else {
                this.getSetter().invoke(object, ObjectUtilities.getInstance().convert(this.getValueType(), value));
            }
            return;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FxRuntimeException("setting property " + this + " failed", e);
        }
    }
}

