/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.reflect.ReflectionHelper;

public abstract class FxTextComponentDelegate
extends FxComponentDelegate
implements FxTextComponent,
UnaryOperator<TextFormatter.Change> {
    private Pos textAlignment;
    private int maxColumns;
    private boolean autoSelect;
    private String pattern;
    private boolean lenient;
    private int scale;
    private boolean unsigned;
    private boolean utc;
    private CaseConversion caseConversion;
    private char filler = (char)32;
    private String validChars;
    private String invalidChars;
    private Function<String, String> textConverter;
    private boolean viewModifiedTriggered;
    private Integer errorOffset;

    protected FxTextComponent getTextComponent() {
        return (FxTextComponent)this.getComponent();
    }

    @Override
    protected void updateChangeable(boolean changeable) {
        if (this.getComponent() instanceof TextInputControl) {
            ((TextInputControl)this.getComponent()).setEditable(changeable);
            this.getNode().setFocusTraversable(changeable);
            this.updateMandatoryStyle(this.isMandatory());
        } else {
            super.updateChangeable(changeable);
        }
    }

    @Override
    protected void updateMandatoryStyle(boolean mandatory) {
        if (this.getComponent() instanceof TextInputControl && !((TextInputControl)this.getComponent()).isEditable()) {
            mandatory = false;
        }
        super.updateMandatoryStyle(mandatory);
    }

    @Override
    protected ReadOnlyBooleanWrapper createChangeableProperty(boolean changeable) {
        ReadOnlyBooleanWrapper changeableProperty;
        if (this.getComponent() instanceof TextInputControl) {
            changeableProperty = new ReadOnlyBooleanWrapper(changeable);
            changeableProperty.bind((ObservableValue)((TextInputControl)this.getComponent()).editableProperty());
        } else {
            changeableProperty = super.createChangeableProperty(changeable);
        }
        return changeableProperty;
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
        if (this.getComponent() instanceof TextInputControl) {
            if (!this.isContainerChangeableIgnored()) {
                ((TextInputControl)this.getComponent()).setEditable(containerChangeable && this.isControlChangeable());
            }
        } else {
            super.setContainerChangeable(containerChangeable);
        }
    }

    @Override
    public Integer getErrorOffset() {
        return this.errorOffset;
    }

    @Override
    public void setErrorOffset(Integer errorOffset) {
        this.errorOffset = errorOffset;
    }

    @Override
    public void setError(String errorMessage) {
        super.setError(errorMessage);
        if (errorMessage == null) {
            this.setErrorOffset(null);
        }
    }

    @Override
    public void showErrorPopup() {
        super.showErrorPopup();
        this.mapErrorOffsetToCaretPosition();
    }

    @Override
    public void triggerViewModified() {
        if (!this.viewModifiedTriggered) {
            super.triggerViewModified();
            this.viewModifiedTriggered = this.isViewModified();
        }
    }

    @Override
    public void updateView() {
        if (!this.isUpdatingView()) {
            super.updateView();
            this.viewModifiedTriggered = false;
        }
    }

    @Override
    public void updateModel() {
        if (!this.isUpdatingModel()) {
            this.viewModifiedTriggered = false;
            this.errorOffset = null;
            if (this.getComponent() instanceof TextInputControl) {
                if (((TextInputControl)this.getComponent()).isEditable()) {
                    super.updateModel();
                }
            } else {
                super.updateModel();
            }
        }
    }

    @Override
    public void saveView() {
        super.saveView();
        this.viewModifiedTriggered = false;
    }

    @Override
    public void setValidChars(String validChars) {
        this.validChars = validChars;
    }

    @Override
    public String getValidChars() {
        return this.validChars;
    }

    @Override
    public void setInvalidChars(String invalidChars) {
        this.invalidChars = invalidChars;
    }

    @Override
    public String getInvalidChars() {
        return this.invalidChars;
    }

    @Override
    public void setTextConverter(Function<String, String> textConverter) {
        this.textConverter = textConverter;
    }

    @Override
    public Function<String, String> getTextConverter() {
        return this.textConverter;
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change t) {
        String text = t.getText();
        if (!text.isEmpty()) {
            String newText;
            int tooMuch;
            text = this.filter(text);
            if (this.maxColumns > 0 && (tooMuch = (newText = t.getControlNewText()).length() - this.maxColumns) > 0) {
                int length = text.length() - tooMuch;
                if (length < 0) {
                    length = 0;
                }
                text = text.substring(0, length);
            }
            int diff = text.length() - t.getText().length();
            t.setText(text);
            if (diff != 0 && !text.isEmpty()) {
                int pos = t.getCaretPosition() + diff;
                if (pos <= 0) {
                    pos = 1;
                } else if (pos > text.length()) {
                    pos = text.length();
                }
                t.setCaretPosition(pos);
                t.setAnchor(pos);
            }
        }
        return t;
    }

    public String filter(String text) {
        char c;
        StringBuilder buf;
        String transValidChars;
        if (this.getValueTranslator() instanceof ValueStringTranslator && (transValidChars = ((ValueStringTranslator)this.getValueTranslator()).getValidChars()) != null) {
            StringBuilder buf2 = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c2 = text.charAt(i);
                if (transValidChars.indexOf(c2) < 0) continue;
                buf2.append(c2);
            }
            text = buf2.toString();
        }
        if (this.validChars != null) {
            buf = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                c = text.charAt(i);
                if (c != this.filler && this.validChars.indexOf(c) < 0) continue;
                buf.append(c);
            }
            text = buf.toString();
        }
        if (this.invalidChars != null) {
            buf = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                c = text.charAt(i);
                if (this.invalidChars.indexOf(c) >= 0) continue;
                buf.append(c);
            }
            text = buf.toString();
        }
        if (this.caseConversion == CaseConversion.UPPER_CASE) {
            text = text.toUpperCase();
        } else if (this.caseConversion == CaseConversion.LOWER_CASE) {
            text = text.toLowerCase();
        }
        if (this.textConverter != null) {
            text = this.textConverter.apply(text);
        }
        return text;
    }

    @Override
    public void setTextAlignment(Pos textAlignment) {
        this.textAlignment = textAlignment;
    }

    @Override
    public Pos getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public void setType(Class<?> type) {
        Pos alignment;
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(this.createValueTranslator(type));
        }
        if (type.isPrimitive()) {
            type = ReflectionHelper.primitiveToWrapperClass(type);
        }
        if (Number.class.isAssignableFrom(type) && (alignment = this.getTextComponent().getTextAlignment()) == null) {
            this.setTextAlignment(Pos.CENTER_RIGHT);
        }
    }

    protected ValueTranslator<?, ?> createValueTranslator(Class<?> type) {
        return FxFactory.getInstance().createValueTranslator(type, String.class, this.getComponent());
    }

    @Override
    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    @Override
    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public void setAutoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    @Override
    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    @Override
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    @Override
    public boolean isUTC() {
        return this.utc;
    }

    @Override
    public void setUTC(boolean utc) {
        this.utc = utc;
    }

    @Override
    public void setCaseConversion(CaseConversion caseConversion) {
        this.caseConversion = caseConversion;
    }

    @Override
    public CaseConversion getCaseConversion() {
        return this.caseConversion;
    }

    @Override
    public void setFiller(char filler) {
        if (Character.isISOControl(filler)) {
            throw new FxRuntimeException("invalid fill character: " + filler);
        }
        this.filler = filler;
    }

    @Override
    public char getFiller() {
        return this.filler;
    }

    @Override
    public void autoSelect() {
        if (this.getComponent() instanceof TextInputControl) {
            if (this.isAutoSelect()) {
                ((TextInputControl)this.getComponent()).selectAll();
            } else {
                ((TextInputControl)this.getComponent()).deselect();
            }
        }
    }
}

