/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.TreeTableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Scale;
import javafx.stage.Popup;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.tentackle.bind.Binder;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.BundleMonkeyHelper;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.ErrorPopupSupported;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilitiesHolder;
import org.tentackle.fx.InfoPopupSupported;
import org.tentackle.fx.InteractiveError;
import org.tentackle.fx.InteractiveErrorFactory;
import org.tentackle.fx.NotificationBuilder;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.component.Note;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.log.Logger;
import org.tentackle.misc.ConcurrencyHelper;
import org.tentackle.misc.Holder;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.validate.ValidationFailedException;
import org.tentackle.validate.ValidationMapper;
import org.tentackle.validate.ValidationResult;

@Service(value=FxUtilities.class)
public class FxUtilities {
    private static final Logger LOGGER = Logger.get(FxUtilities.class);
    private final Executor blockingFxExecutor = ConcurrencyHelper.createBlockingExecutor(Platform::runLater);
    private String helpURL;
    private boolean darkMode;
    private static final double XY_STEP_DIVISOR = 32.0;
    private static final int MAX_LOCATION_LOOP = 4;

    public static FxUtilities getInstance() {
        return FxUtilitiesHolder.INSTANCE;
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
    }

    public void applyStylesheets(Scene scene) {
        scene.getStylesheets().add((Object)(this.isDarkMode() ? "/org/tentackle/fx/tentackle_dark.css" : "/org/tentackle/fx/tentackle.css"));
    }

    public Cursor getDefaultCursor(Node node) {
        return Cursor.DEFAULT;
    }

    public Cursor getWaitCursor(Node node) {
        return Cursor.WAIT;
    }

    public boolean isLenientMoneyInput(FxTextComponent component) {
        return false;
    }

    public int getDefaultTextAreaColumns(FxTextArea textArea) {
        return 30;
    }

    public long getPrefixSelectionTimeout() {
        return 750L;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void showHelp(Object owner) {
        String url;
        String compUrl = null;
        FxControl control = null;
        if (owner instanceof FxControl) {
            control = (FxControl)owner;
        }
        while (compUrl == null && control != null) {
            compUrl = control.getHelpUrl();
            control = control.getParentContainer();
        }
        StringBuilder buf = new StringBuilder();
        String urlPrefix = this.getHelpURL();
        if (urlPrefix != null) {
            buf.append(urlPrefix);
            if (!urlPrefix.endsWith("/")) {
                buf.append('/');
            }
        }
        if (compUrl != null) {
            buf.append(compUrl);
        }
        if (!(url = buf.toString()).isEmpty()) {
            this.run(owner, () -> this.browse(URI.create(url)));
        }
    }

    public void terminate() {
        Platform.exit();
    }

    public void browse(URI uri) {
        try {
            LOGGER.info("launching browser for {0}", new Object[]{uri});
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException ex) {
            throw new FxRuntimeException(MessageFormat.format(FxFxBundle.getString("CANT OPEN URL {0}"), uri), ex);
        }
    }

    public void edit(Object owner, File file) {
        this.run(owner, () -> {
            try {
                LOGGER.info("launching EDIT action for {0}", new Object[]{file});
                Desktop.getDesktop().edit(file);
            }
            catch (IOException | UnsupportedOperationException ex) {
                LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), file});
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException ex2) {
                    throw new FxRuntimeException(MessageFormat.format(FxFxBundle.getString("CANT OPEN FILE {0}"), file.getName()), ex2);
                }
            }
        });
    }

    public Stage getStage(Node node) {
        Stage stage = null;
        while (node != null) {
            Window window;
            Scene scene = node.getScene();
            if (scene != null && (window = scene.getWindow()) instanceof Stage) {
                stage = (Stage)window;
                break;
            }
            node = node.getParent();
        }
        return stage;
    }

    public Window getWindow(Object owner) {
        if (owner instanceof Scene) {
            Scene scene = (Scene)owner;
            owner = scene.getWindow();
        } else if (owner instanceof Node) {
            Node node = (Node)owner;
            owner = this.getStage(node);
        }
        if (owner instanceof Window) {
            Window window = (Window)owner;
            return window;
        }
        throw new FxRuntimeException("cannot determine owner");
    }

    public boolean isModal(Stage stage) {
        boolean bl;
        block6: {
            block5: {
                if (stage == null) break block5;
                switch (stage.getModality()) {
                    case APPLICATION_MODAL: {
                        break;
                    }
                    case WINDOW_MODAL: {
                        if (stage.getOwner() != null) {
                            break;
                        }
                        break block5;
                    }
                    default: {
                        break block5;
                    }
                }
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public void closeStageHierarchy(Node node, Stage stopStage) {
        Stage stage = this.getStage(node);
        while (stage != null && stage != stopStage) {
            stage.close();
            Window owner = stage.getOwner();
            if (!(owner instanceof Stage)) break;
            stage = (Stage)owner;
        }
    }

    public String dumpComponentHierarchy(Node node) {
        StringBuilder buf = new StringBuilder();
        buf.append(">>> ").append("(LOCALE=").append(LocaleProvider.getInstance().getLocale()).append(")").append(" component hierarchy within ");
        Stage stage = this.getStage(node);
        if (stage != null) {
            buf.append("stage '").append(stage.getTitle()).append("'");
        }
        while (node != null) {
            BindingMember member;
            FxComponent fxComponent;
            FxComponentBinding binding;
            TableConfiguration configuration;
            buf.append("\n    ");
            if (node instanceof FxContainer) {
                FxController controller = ((FxContainer)node).getController();
                if (controller != null) {
                    FxControllerService annotation = controller.getClass().getAnnotation(FxControllerService.class);
                    String bundleName = null;
                    if (annotation != null) {
                        if (annotation.resources().isEmpty()) {
                            bundleName = controller.getClass().getName();
                        } else if (!annotation.resources().equals("NONE")) {
                            bundleName = annotation.resources();
                        }
                    }
                    if (bundleName != null) {
                        buf.append(BundleMonkeyHelper.createNavigationString(bundleName));
                    }
                    if (!controller.getClass().getName().equals(bundleName)) {
                        if (bundleName != null) {
                            buf.append(' ');
                        }
                        buf.append(controller.getClass().getSimpleName());
                    }
                    buf.append(": ");
                }
            } else if (node instanceof FxTableView) {
                configuration = ((FxTableView)node).getConfiguration();
                if (configuration != null) {
                    if (configuration.getBaseBundleName() != null) {
                        buf.append(BundleMonkeyHelper.createNavigationString(configuration.getBaseBundleName())).append(' ');
                    }
                    buf.append(configuration.getName()).append(": ");
                }
            } else if (node instanceof FxTreeTableView && (configuration = ((FxTreeTableView)node).getConfiguration()) != null) {
                if (configuration.getBaseBundleName() != null) {
                    buf.append(BundleMonkeyHelper.createNavigationString(configuration.getBaseBundleName())).append(' ');
                }
                buf.append(configuration.getName()).append(": ");
            }
            buf.append(node).append(" @ [").append(node.getLayoutX()).append("/").append(node.getLayoutY()).append(']');
            if (node instanceof FxComponent && (binding = (fxComponent = (FxComponent)node).getBinding()) != null && (member = binding.getMember()) != null) {
                buf.append(" bound to '");
                Class type = member.getType();
                if (type != null) {
                    String innerTypeName;
                    Class innerType;
                    String typeName = type.getSimpleName();
                    buf.append(typeName);
                    Type genericType = member.getGenericType();
                    if (genericType != null && (innerType = ReflectionHelper.extractGenericInnerTypeClass((Type)genericType)) != null && !(innerTypeName = innerType.getSimpleName()).equals(typeName)) {
                        buf.append('<').append(innerTypeName).append('>');
                    }
                    buf.append(' ');
                }
                buf.append(member).append("'");
                ValueTranslator<?, ?> valueTranslator = fxComponent.getValueTranslator();
                if (valueTranslator != null) {
                    buf.append(" via ").append(valueTranslator.getClass().getSimpleName());
                }
            }
            node = node.getParent();
        }
        buf.append("\n<<<");
        return buf.toString();
    }

    public void runAndWait(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            throw new FxRuntimeException("calling thread is the FX application thread");
        }
        this.blockingFxExecutor.execute(runnable);
    }

    public void run(Object owner, final Runnable runnable) {
        javafx.concurrent.Service<Void> service = new javafx.concurrent.Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() {
                        runnable.run();
                        return null;
                    }
                };
            }
        };
        service.setOnFailed(event -> {
            Throwable exception = event.getSource().getException();
            if (exception != null) {
                LOGGER.warning("FX background execution failed", exception);
                Platform.runLater(() -> this.showErrorDialog(owner, exception.getMessage(), exception, null));
            }
        });
        service.start();
    }

    public void showNotification(Object owner, Popup popup, Parent notification, Runnable onClose) {
        popup.getContent().add((Object)notification);
        popup.setAutoHide(true);
        if (onClose != null) {
            popup.setOnHidden(event -> Platform.runLater((Runnable)onClose));
        }
        Window window = this.getWindow(owner);
        popup.addEventFilter(WindowEvent.WINDOW_SHOWN, event -> {
            popup.setAnchorX(window.getX() + (window.getWidth() - popup.getWidth()) / 2.0);
            popup.setAnchorY(window.getY() + (window.getHeight() - popup.getHeight()) / 2.0);
        });
        popup.show(window);
    }

    public void showInfoDialog(Object owner, String message, Runnable onClose) {
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().type(NotificationBuilder.Type.INFORMATION).text(message).button(FxFxBundle.getString("OK"), null, false, null).hide(() -> ((Popup)popup).hide()).build();
        this.showNotification(owner, popup, notification, onClose);
    }

    public void showWarningDialog(Object owner, String message, Runnable onClose) {
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().type(NotificationBuilder.Type.WARNING).text(message).button(FxFxBundle.getString("OK"), null, false, null).hide(() -> ((Popup)popup).hide()).build();
        this.showNotification(owner, popup, notification, onClose);
    }

    public void showQuestionDialog(Object owner, String message, boolean defaultYes, Consumer<Boolean> answer) {
        Holder result = new Holder((Object)Boolean.FALSE);
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().type(NotificationBuilder.Type.QUESTION).text(message).button(FxFxBundle.getString("NO"), null, !defaultYes, null).button(FxFxBundle.getString("YES"), null, defaultYes, () -> result.accept((Object)Boolean.TRUE)).hide(() -> ((Popup)popup).hide()).build();
        popup.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            if ("0".equals(event.getCharacter())) {
                event.consume();
                popup.hide();
            } else if ("1".equals(event.getCharacter())) {
                event.consume();
                result.accept((Object)Boolean.TRUE);
                popup.hide();
            }
        });
        this.showNotification(owner, popup, notification, () -> answer.accept((Boolean)result.get()));
    }

    public void showErrorDialog(Object owner, String message, Throwable t, Runnable onClose) {
        String details;
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            details = sw.toString();
        } else {
            details = null;
        }
        Popup popup = new Popup();
        Parent notification = FxFactory.getInstance().createNotificationBuilder().type(NotificationBuilder.Type.ERROR).text(message).details(details).button(FxFxBundle.getString("OK"), null, false, null).hide(() -> ((Popup)popup).hide()).build();
        try {
            this.showNotification(owner, popup, notification, onClose);
        }
        catch (RuntimeException rx) {
            if (details != null) {
                LOGGER.severe(details);
            }
            throw rx;
        }
    }

    public PopupWindow showErrorPopup(ErrorPopupSupported component) {
        Note popup = null;
        String errorMessage = component.getError();
        if (!StringHelper.isAllWhitespace((String)errorMessage)) {
            Note note = (Note)((Object)Fx.create(Note.class));
            note.setPosition(Note.Position.RIGHT);
            note.setType(Note.Type.ERROR);
            note.setText(errorMessage);
            note.show((Node)component);
            popup = note;
        }
        return popup;
    }

    public PopupWindow showInfoPopup(InfoPopupSupported component) {
        Note popup = null;
        String infoMessage = component.getInfo();
        if (!StringHelper.isAllWhitespace((String)infoMessage)) {
            Note note = (Note)((Object)Fx.create(Note.class));
            note.setPosition(Note.Position.RIGHT);
            note.setType(Note.Type.INFO);
            note.setText(infoMessage);
            note.show((Node)component);
            popup = note;
        }
        return popup;
    }

    public InteractiveError createInteractiveError(ValidationResult validationResult, NavigableSet<ValidationMapper> validationMappers, Binder binder) {
        return InteractiveErrorFactory.getInstance().createInteractiveError(validationMappers, binder, validationResult);
    }

    public List<InteractiveError> createInteractiveErrors(List<ValidationResult> validationResults, NavigableSet<ValidationMapper> validationMappers, Binder binder) {
        ArrayList<InteractiveError> errors = new ArrayList<InteractiveError>();
        for (ValidationResult validationResult : validationResults) {
            errors.add(this.createInteractiveError(validationResult, validationMappers, binder));
        }
        return errors;
    }

    public boolean showValidationResults(Object owner, ValidationFailedException ex, NavigableSet<ValidationMapper> validationMappers, Binder binder) {
        StringBuilder warnings = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        List<InteractiveError> errorList = this.createInteractiveErrors(ex.getResults(), validationMappers, binder);
        for (InteractiveError error : errorList) {
            if (error.isWarning()) {
                if (!warnings.isEmpty()) {
                    warnings.append('\n');
                }
                warnings.append(error.getText());
                continue;
            }
            if (!errors.isEmpty()) {
                errors.append('\n');
            }
            errors.append(error.getText());
        }
        if (!warnings.isEmpty() && !errors.isEmpty()) {
            errors.append("\n\n").append((CharSequence)warnings);
            warnings.setLength(0);
        }
        if (!errors.isEmpty()) {
            this.showErrorDialog(owner, errors.toString(), null, () -> {
                for (InteractiveError error : errorList) {
                    FxControl patt27387$temp = error.getControl();
                    if (!(patt27387$temp instanceof FxComponent)) continue;
                    FxComponent component = (FxComponent)patt27387$temp;
                    if (error.isWarning()) {
                        component.setInfo(error.getText());
                        continue;
                    }
                    component.setError(error.getText());
                }
            });
        } else if (!warnings.isEmpty()) {
            this.showInfoDialog(owner, warnings.toString(), () -> {
                for (InteractiveError error : errorList) {
                    FxControl patt27823$temp = error.getControl();
                    if (!(patt27823$temp instanceof FxComponent)) continue;
                    FxComponent component = (FxComponent)patt27823$temp;
                    component.setInfo(error.getText());
                }
            });
        }
        return !errors.isEmpty();
    }

    public void setupFocusHandling(Control control) {
        if (control instanceof FxComponent) {
            FxComponent component = (FxComponent)control;
            control.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    FxUtilities.getInstance().focusGained(component);
                    if (component.getError() == null) {
                        component.showInfoPopup();
                    }
                    component.showErrorPopup();
                } else {
                    FxUtilities.getInstance().focusLost(component);
                    component.hideInfoPopup();
                    component.hideErrorPopup();
                }
            });
            control.hoverProperty().addListener((observable, oldValue, newValue) -> {
                if (!control.isFocused()) {
                    if (newValue.booleanValue()) {
                        if (component.getError() == null) {
                            component.showInfoPopup();
                        }
                        component.showErrorPopup();
                    } else {
                        component.hideInfoPopup();
                        component.hideErrorPopup();
                    }
                }
            });
        }
    }

    public void focusGained(FxComponent component) {
        if (component.getError() == null) {
            component.updateView();
            if (component.isChangeable() && component instanceof FxTextComponent) {
                Platform.runLater(((FxTextComponent)component)::autoSelect);
            }
        }
    }

    public void focusLost(FxComponent component) {
        component.updateModel();
        if (component.isModelUpdated() && component.getError() == null) {
            component.updateView();
            ValueTranslator<?, ?> translator = component.getValueTranslator();
            if (translator != null && translator.needsToModelTwice()) {
                component.updateModel();
            }
        }
    }

    public void remapKeys(Control control) {
        final ArrayList mappedEvents = new ArrayList();
        control.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (mappedEvents.remove(event)) {
                    return;
                }
                if (KeyCode.ENTER == event.getCode()) {
                    KeyEvent newEvent = this.remap(event, KeyCode.TAB);
                    mappedEvents.add(newEvent);
                    event.consume();
                    Event.fireEvent((EventTarget)event.getTarget(), (Event)newEvent);
                }
            }

            private KeyEvent remap(KeyEvent event, KeyCode code) {
                KeyEvent newEvent = new KeyEvent(event.getEventType(), event.getCharacter(), event.getText(), code, event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown());
                return newEvent.copyFor(event.getSource(), event.getTarget());
            }
        });
    }

    public void filterKeys(Control control) {
        if (control instanceof FxComponent) {
            control.addEventFilter(KeyEvent.ANY, event -> {
                if (!(event.isAltDown() || event.isMetaDown() || event.isShiftDown())) {
                    FxComponent comp = (FxComponent)control;
                    if (event.isControlDown()) {
                        Object viewObject;
                        if (event.getCode() == KeyCode.Z) {
                            if (comp.isViewModified() && comp.isSavedViewObjectValid()) {
                                if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                                    Object viewObject2 = comp.getViewObject();
                                    comp.setViewObject(comp.getSavedViewObject());
                                    comp.getDelegate().setLastViewObject(viewObject2);
                                }
                                event.consume();
                            }
                        } else if (event.getCode() == KeyCode.Y && (viewObject = comp.getDelegate().getLastViewObject()) != null) {
                            if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                                comp.setViewObject(viewObject);
                            }
                            event.consume();
                        }
                    } else if (event.getCode() == KeyCode.F1) {
                        if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                            comp.showHelp();
                        }
                        event.consume();
                    }
                }
            });
        }
    }

    public void registerWindowEventFilters(Window window) {
        window.addEventFilter(MouseEvent.ANY, event -> {
            if (event.isShiftDown() && event.isControlDown() && !event.isMetaDown() && !event.isAltDown() && event.isPopupTrigger()) {
                Node node;
                event.consume();
                PickResult pickResult = event.getPickResult();
                if (pickResult != null && (node = pickResult.getIntersectedNode()) != null) {
                    String componentHierarchy = this.dumpComponentHierarchy(node);
                    LOGGER.info(() -> "\n" + componentHierarchy);
                    BundleMonkeyHelper.navigateTo(componentHierarchy);
                }
            }
        });
    }

    public <T> void expandAll(TreeItem<T> treeItem) {
        if (treeItem != null && !treeItem.isLeaf() && !this.isValueInParentPath(treeItem)) {
            treeItem.setExpanded(true);
            ObservableList children = treeItem.getChildren();
            if (children != null) {
                for (TreeItem childItem : children) {
                    this.expandAll(childItem);
                }
            }
        }
    }

    public <T> boolean isValueInParentPath(TreeItem<T> treeItem) {
        boolean inPath = false;
        Object value = treeItem.getValue();
        if (value != null) {
            for (TreeItem parentItem = treeItem.getParent(); parentItem != null; parentItem = parentItem.getParent()) {
                if (!value.equals(parentItem.getValue())) continue;
                inPath = true;
                break;
            }
        }
        return inPath;
    }

    public <T> void collapseAll(TreeItem<T> treeItem) {
        if (treeItem != null && treeItem.isExpanded()) {
            treeItem.setExpanded(false);
            ObservableList children = treeItem.getChildren();
            if (children != null) {
                for (TreeItem childItem : children) {
                    this.collapseAll(childItem);
                }
            }
        }
    }

    public <T> void collapseAll(Collection<TreeItem<T>> treeItems) {
        if (treeItems != null) {
            for (TreeItem<T> treeItem : treeItems) {
                this.collapseAll(treeItem);
            }
        }
    }

    public void print(Node node) {
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && job.showPrintDialog((Window)this.getStage(node))) {
            Scale scale = FxUtilities.getScale(node, job);
            node.getTransforms().add((Object)scale);
            boolean success = job.printPage(node);
            node.getTransforms().remove((Object)scale);
            if (success) {
                job.endJob();
            }
        }
    }

    private static Scale getScale(Node node, PrinterJob job) {
        PageLayout pageLayout = job.getJobSettings().getPageLayout();
        double scaleX = 1.0;
        if (pageLayout.getPrintableWidth() < node.getBoundsInParent().getWidth()) {
            scaleX = pageLayout.getPrintableWidth() / node.getBoundsInParent().getWidth();
        }
        double scaleY = 1.0;
        if (pageLayout.getPrintableHeight() < node.getBoundsInParent().getHeight()) {
            scaleY = pageLayout.getPrintableHeight() / node.getBoundsInParent().getHeight();
        }
        double scaleXY = Double.min(scaleX, scaleY);
        return new Scale(scaleXY, scaleXY);
    }

    public String getBindingOption(String options, String key) {
        String option = null;
        StringTokenizer stok = new StringTokenizer(options.toUpperCase(Locale.ROOT), ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().trim();
            if (!token.startsWith(key)) continue;
            option = token;
            break;
        }
        return option;
    }

    public void applyBindingOptions(FxTextComponent comp, BindingMember member, String options) {
        this.applyBindingOptions(comp, null, member, options);
    }

    public void applyBindingOptions(TableColumnConfiguration columnConfiguration, BindingMember member, String options) {
        this.applyBindingOptions(null, columnConfiguration, member, options);
    }

    private void applyBindingOptions(FxTextComponent comp, TableColumnConfiguration columnConfiguration, BindingMember member, String options) {
        if (options != null) {
            StringTokenizer stok = new StringTokenizer(options.toUpperCase(Locale.ROOT), ",");
            while (stok.hasMoreTokens()) {
                boolean processed;
                String token = stok.nextToken().trim();
                if (comp != null) {
                    processed = this.applyBindingOption(comp, member, token);
                } else if (columnConfiguration != null) {
                    processed = this.applyBindingOption(columnConfiguration, member, token);
                } else {
                    throw new BindingException("unsupported @Bindable target " + member);
                }
                if (processed) continue;
                throw new BindingException("unsupported @Bindable option \"" + token + "\") in " + member);
            }
        }
    }

    protected boolean applyBindingOption(FxTextComponent comp, BindingMember member, String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            comp.setCaseConversion(CaseConversion.UPPER_CASE);
            processed = true;
        } else if ("LC".equals(option)) {
            comp.setCaseConversion(CaseConversion.LOWER_CASE);
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            comp.setAutoSelect(true);
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            comp.setAutoSelect(false);
            processed = true;
        } else if ("UTC".equals(option)) {
            comp.setUTC(true);
            processed = true;
        } else if ("-UTC".equals(option)) {
            comp.setUTC(false);
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            comp.setUnsigned(true);
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            comp.setUnsigned(false);
            processed = true;
        } else if ("DIGITS".equals(option)) {
            comp.setValidChars("0123456789");
            processed = true;
        } else if (option.startsWith("COLS=")) {
            try {
                comp.setColumns(Integer.parseInt(option.substring("COLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid COLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("MAXCOLS=")) {
            try {
                comp.setMaxColumns(Integer.parseInt(option.substring("MAXCOLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid MAXCOLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("SCALE=")) {
            try {
                comp.setScale(Integer.parseInt(option.substring("SCALE".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("LINES=")) {
            if (comp instanceof TextArea) {
                try {
                    ((TextArea)comp).setPrefRowCount(Integer.parseInt(option.substring("LINES".length() + 1)));
                    processed = true;
                }
                catch (NumberFormatException ex) {
                    throw new BindingException("invalid LINES @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
                }
            } else {
                throw new BindingException("LINES @Bindable option \"" + option + "\") in " + member + " not applicable to " + comp.getClass().getName());
            }
        }
        return processed;
    }

    protected boolean applyBindingOption(TableColumnConfiguration columnConfiguration, BindingMember member, String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            columnConfiguration.setCaseConversion(Boolean.TRUE);
            processed = true;
        } else if ("LC".equals(option)) {
            columnConfiguration.setCaseConversion(Boolean.FALSE);
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            columnConfiguration.setAutoSelect(Boolean.TRUE);
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            columnConfiguration.setAutoSelect(Boolean.FALSE);
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            columnConfiguration.setUnsigned(true);
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            columnConfiguration.setUnsigned(false);
            processed = true;
        } else if ("DIGITS".equals(option)) {
            columnConfiguration.setValidChars("0123456789");
            processed = true;
        } else if (option.startsWith("MAXCOLS=")) {
            try {
                columnConfiguration.setMaxColumns(Integer.parseInt(option.substring("MAXCOLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid MAXCOLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("SCALE=")) {
            try {
                columnConfiguration.setScale(Integer.parseInt(option.substring("SCALE".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("COLS=") || option.startsWith("LINES=")) {
            processed = true;
        }
        return processed;
    }

    public void resizeColumnsToFitContent(TableView<?> table) {
        TableViewSkin tableSkin = (TableViewSkin)table.getSkin();
        VirtualFlow virtualFlow = (VirtualFlow)tableSkin.getChildren().get(1);
        IndexedCell iCell = virtualFlow.getFirstVisibleCell();
        if (iCell != null) {
            int first = iCell.getIndex();
            iCell = virtualFlow.getLastVisibleCell();
            if (iCell != null) {
                int last = iCell.getIndex();
                for (TableColumn column : table.getColumns()) {
                    TableCell cell;
                    Callback cellFactory;
                    if (!column.isVisible() || (cellFactory = column.getCellFactory()) == null || (cell = (TableCell)cellFactory.call((Object)column)) == null) continue;
                    Font cellFont = cell.getFont();
                    Font headerFont = Font.font((String)cellFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)cellFont.getSize());
                    cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
                    double maxWidth = 20.0;
                    cell.updateTableColumn(column);
                    cell.updateTableView(table);
                    cell.setText(column.getText());
                    cell.setGraphic(column.getGraphic());
                    cell.setFont(headerFont);
                    maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    cell.setFont(cellFont);
                    for (int row = first; row <= last; ++row) {
                        cell.updateIndex(row);
                        maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    }
                    table.resizeColumn(column, maxWidth - column.getWidth());
                }
            }
        }
    }

    public void resizeColumnsToFitContent(TreeTableView<?> table) {
        TreeTableViewSkin tableSkin = (TreeTableViewSkin)table.getSkin();
        VirtualFlow virtualFlow = (VirtualFlow)tableSkin.getChildren().get(1);
        IndexedCell iCell = virtualFlow.getFirstVisibleCell();
        if (iCell != null) {
            int first = iCell.getIndex();
            iCell = virtualFlow.getLastVisibleCell();
            if (iCell != null) {
                int last = iCell.getIndex();
                boolean firstVisibleColumn = true;
                for (TreeTableColumn column : table.getColumns()) {
                    TreeTableCell cell;
                    Callback cellFactory;
                    if (!column.isVisible() || (cellFactory = column.getCellFactory()) == null || (cell = (TreeTableCell)cellFactory.call((Object)column)) == null) continue;
                    Font cellFont = cell.getFont();
                    Font headerFont = Font.font((String)cellFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)cellFont.getSize());
                    cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
                    double maxWidth = 20.0;
                    cell.updateTableColumn(column);
                    cell.updateTreeTableView(table);
                    cell.setText(column.getText());
                    cell.setGraphic(column.getGraphic());
                    cell.setFont(headerFont);
                    maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    cell.setFont(cellFont);
                    for (int row = first; row <= last; ++row) {
                        cell.updateIndex(row);
                        maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    }
                    if (firstVisibleColumn) {
                        maxWidth += 50.0;
                        firstVisibleColumn = false;
                    }
                    table.resizeColumn(column, maxWidth - column.getWidth());
                }
            }
        }
    }

    public ObservableList<Stage> getAllShowingStages() {
        ObservableList stages = FXCollections.observableArrayList();
        Window.getWindows().forEach(w -> {
            if (w instanceof Stage) {
                stages.add((Object)((Stage)w));
            }
        });
        return stages;
    }

    public Point2D determineCenteredLocation(Window window) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double windowWidth = window.getWidth();
        double windowHeight = window.getHeight();
        if (window.getWidth() > screenSize.getWidth()) {
            windowWidth = screenSize.getWidth();
        }
        if (windowHeight > screenSize.getHeight()) {
            windowHeight = screenSize.getHeight();
        }
        return new Point2D((screenSize.getWidth() - windowWidth) / 2.0, (screenSize.getHeight() - windowHeight) / 2.0);
    }

    public Point2D determinePreferredStageLocation(Stage stage) {
        Point2D location = new Point2D(stage.getX(), stage.getY());
        if (location.getX() == 0.0 && location.getY() == 0.0) {
            Window owner = stage.getOwner();
            location = owner != null ? new Point2D(owner.getX() + (owner.getWidth() - stage.getWidth()) / 2.0, owner.getY() + (owner.getHeight() - stage.getHeight()) / 2.0) : this.determineCenteredLocation((Window)stage);
        }
        return this.determineAlignedStageLocation(stage, location);
    }

    public Point2D determineAlignedStageLocation(Stage stage, Point2D location) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double maxWidth = screenSize.getWidth() - screenSize.getWidth() / 32.0;
        double maxHeight = screenSize.getHeight() - screenSize.getHeight() / 32.0;
        double minX = screenSize.getWidth() / 32.0;
        double minY = screenSize.getHeight() / 32.0;
        if (location.getX() + stage.getWidth() > maxWidth) {
            location = new Point2D(maxWidth - stage.getWidth(), location.getY());
        }
        if (location.getX() < 0.0) {
            location = new Point2D(0.0, location.getY());
        } else if (location.getX() < minX && location.getX() + stage.getWidth() < maxWidth) {
            location = new Point2D(minX, location.getY());
        }
        if (location.getY() + stage.getHeight() > maxHeight) {
            location = new Point2D(location.getX(), maxHeight - stage.getHeight());
        }
        if (location.getY() < 0.0) {
            location = new Point2D(location.getX(), 0.0);
        } else if (location.getY() < minY && location.getY() + stage.getHeight() < maxHeight) {
            location = new Point2D(location.getX(), minY);
        }
        return this.determineFreeStageLocation(stage, location);
    }

    public VirtualFlow getVirtualFlow(Skinnable control) {
        ObservableList children;
        VirtualFlow flow = null;
        Skin skin = control.getSkin();
        if (skin instanceof SkinBase && (children = ((SkinBase)skin).getChildren()) != null) {
            for (Object child : children) {
                if (!(child instanceof VirtualFlow)) continue;
                flow = (VirtualFlow)child;
                break;
            }
        }
        return flow;
    }

    public int computeScrollToCentered(Skinnable control, int row, int numRow) {
        VirtualFlow flow = this.getVirtualFlow(control);
        if (flow != null) {
            IndexedCell firstVisibleCell = flow.getFirstVisibleCell();
            IndexedCell lastVisibleCell = flow.getLastVisibleCell();
            if (firstVisibleCell != null && lastVisibleCell != null) {
                int viewSize = lastVisibleCell.getIndex() - firstVisibleCell.getIndex() + 1;
                if ((row -= viewSize / 2) + viewSize > numRow) {
                    row = numRow - viewSize;
                }
                if (row < 0) {
                    row = 0;
                }
            }
        }
        return row;
    }

    public String getCsvSeparator() {
        return ";";
    }

    private double maxColumnWidth(double maxWidth, TableCell cell, TableViewSkin<?> tableSkin) {
        if (cell.getText() != null && !cell.getText().isEmpty() || cell.getGraphic() != null) {
            tableSkin.getChildren().add((Object)cell);
            cell.applyCss();
            maxWidth = Math.max(maxWidth, cell.prefWidth(-1.0));
            tableSkin.getChildren().remove((Object)cell);
        }
        return maxWidth;
    }

    private double maxColumnWidth(double maxWidth, TreeTableCell cell, TreeTableViewSkin<?> treeTableSkin) {
        if (cell.getText() != null && !cell.getText().isEmpty() || cell.getGraphic() != null) {
            treeTableSkin.getChildren().add((Object)cell);
            cell.applyCss();
            maxWidth = Math.max(maxWidth, cell.prefWidth(-1.0));
            treeTableSkin.getChildren().remove((Object)cell);
        }
        return maxWidth;
    }

    private Point2D determineFreeStageLocation(Stage stage, Point2D startLocation) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double stepX = screenSize.getWidth() / 32.0;
        double stepY = screenSize.getHeight() / 32.0;
        double x = startLocation.getX() + stage.getWidth() / 2.0;
        double y = startLocation.getY() + stage.getHeight() / 2.0;
        double dx = x > screenSize.getWidth() / 2.0 ? -stepX : stepX;
        double dy = y > screenSize.getHeight() / 2.0 ? -stepY : stepY;
        for (int loop = 0; loop < 4; ++loop) {
            boolean abort = false;
            Point2D location = startLocation;
            while (!abort && this.isStageOverlapping(stage, location, dx, dy)) {
                if ((location = location.add(dx, dy)).getX() < 0.0) {
                    location = new Point2D(0.0, location.getY());
                    abort = true;
                }
                if (location.getX() + stage.getWidth() > screenSize.getWidth()) {
                    location = new Point2D(screenSize.getWidth() - stage.getWidth(), location.getY());
                    abort = true;
                }
                if (location.getY() < 0.0) {
                    location = new Point2D(location.getX(), 0.0);
                    abort = true;
                }
                if (!(location.getY() + stage.getHeight() > screenSize.getHeight())) continue;
                location = new Point2D(location.getX(), screenSize.getHeight() - stage.getHeight());
                abort = true;
            }
            if (!abort) {
                return location;
            }
            if (dx > 0.0 && dy > 0.0) {
                dx = -stepX;
                continue;
            }
            if (dx < 0.0 && dy > 0.0) {
                dy = -stepY;
                continue;
            }
            if (dx < 0.0 && dy < 0.0) {
                dx = stepX;
                continue;
            }
            if (!(dx > 0.0) || !(dy < 0.0)) continue;
            dy = stepY;
        }
        return startLocation;
    }

    private boolean isStageOverlapping(Stage stage, Point2D location, double dx, double dy) {
        Window owner = stage.getOwner();
        if (dx < 0.0) {
            dx = -dx;
        }
        if (dy < 0.0) {
            dy = -dy;
        }
        for (Stage w : this.getAllShowingStages()) {
            Window o = w.getOwner();
            if (w == stage || o != owner || !(location.getX() <= w.getX() + dx && location.getX() + stage.getWidth() + dx >= w.getX() + w.getWidth()) && (!(location.getY() <= w.getY() + dy) || !(location.getY() + stage.getHeight() + dy >= w.getY() + w.getHeight()))) continue;
            return true;
        }
        return false;
    }
}

