/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.GraphicProvider;
import org.tentackle.misc.Holder;
import org.tentackle.reflect.ReflectionHelper;

public abstract class ImageGraphicProvider
implements GraphicProvider {
    private static final String[] EXTENSIONS = new String[]{".png", ".gif", ".jpg"};
    private final Map<String, Holder<Image>> imageMap = new ConcurrentHashMap<String, Holder<Image>>();
    private final String imagePath;

    public ImageGraphicProvider(String imagePath) {
        String pkgPath = ReflectionHelper.getPackagePathName(this.getClass());
        this.imagePath = imagePath == null ? ("/".equals(pkgPath) ? "" : pkgPath) + "/images/" : imagePath;
    }

    public ImageGraphicProvider() {
        this(null);
    }

    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public Node createGraphic(String name) {
        Image image = this.getImage(name);
        if (image == null) {
            throw new FxRuntimeException("no such image '" + name + "'");
        }
        return new ImageView(image);
    }

    protected Image getImage(String name) {
        Holder imageHolder;
        int ndx = name.lastIndexOf(47);
        if (ndx >= 0) {
            name = name.substring(ndx + 1);
        }
        if ((ndx = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, ndx);
        }
        if ((imageHolder = this.imageMap.get(name)) == null) {
            imageHolder = new Holder();
            for (String type : this.getExtensions()) {
                String url = this.imagePath + name + type;
                try (InputStream is = this.getClass().getResourceAsStream(url);){
                    if (is == null) continue;
                    imageHolder.accept((Object)new Image(is));
                    break;
                }
                catch (IOException ix) {
                    throw new FxRuntimeException("loading image failed for " + url, ix);
                }
            }
            this.imageMap.put(name, (Holder<Image>)imageHolder);
        }
        return (Image)imageHolder.get();
    }
}

