/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javafx.util.StringConverter;
import org.tentackle.common.Compare;

public abstract class NavigationLetterStringConverter<T>
extends StringConverter<T> {
    private final TreeMap<Key, T> navigationMap = new TreeMap();

    public NavigationLetterStringConverter(Collection<T> objects) {
        objects.forEach(o -> this.navigationMap.put(new Key(this.getNavigationLetters(o), this.getName(o)), o));
    }

    public abstract String getNavigationLetters(T var1);

    public abstract String getName(T var1);

    public Collection<T> getSortedObjects() {
        return this.navigationMap.values();
    }

    public String toString(T object) {
        return object == null ? null : this.getNavigationLetters(object);
    }

    public T fromString(String string) {
        Iterator<Map.Entry<Key, T>> iterator;
        T object = null;
        if (string != null && (iterator = this.navigationMap.tailMap(new Key(string, null)).entrySet().iterator()).hasNext()) {
            object = iterator.next().getValue();
        }
        return object;
    }

    private record Key(String navigationLetters, String name) implements Comparable<Key>
    {
        @Override
        public int compareTo(Key other) {
            if (other != null) {
                int rv = Compare.compare((Comparable)((Object)this.navigationLetters), (Comparable)((Object)other.navigationLetters));
                if (rv == 0) {
                    rv = Compare.compare((Comparable)((Object)this.name), (Comparable)((Object)other.name));
                }
                return rv;
            }
            return Integer.MAX_VALUE;
        }
    }
}

