/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.tentackle.misc.ShortLongText;

public class ShortLongTextCellFactory<T>
implements Callback<ListView<T>, ListCell<T>> {
    private static final double GRID_GAP = 20.0;
    private boolean listenerPending = true;
    private boolean widthPending;
    private double shortWidth;
    private double longWidth;

    public ListCell<T> call(final ListView<T> listView) {
        if (this.listenerPending) {
            listView.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (oldValue.booleanValue()) {
                    this.widthPending = true;
                }
            });
            this.listenerPending = false;
            this.widthPending = true;
        }
        return new ListCell<T>(){
            private GridPane gridPane;
            private final Label shortLabel = new Label();
            private final Label longLabel = new Label();
            private double lastShortWidth;
            private double lastLongWidth;

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                } else {
                    if (ShortLongTextCellFactory.this.widthPending) {
                        ShortLongTextCellFactory.this.computeWidths(this.getFont(), listView.getItems());
                        ShortLongTextCellFactory.this.widthPending = false;
                    }
                    if (this.gridPane == null) {
                        this.gridPane = new GridPane();
                        if (ShortLongTextCellFactory.this.longWidth > 0.0) {
                            this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(ShortLongTextCellFactory.this.shortWidth, ShortLongTextCellFactory.this.shortWidth, ShortLongTextCellFactory.this.shortWidth), new ColumnConstraints(ShortLongTextCellFactory.this.longWidth, ShortLongTextCellFactory.this.longWidth, ShortLongTextCellFactory.this.longWidth)});
                            this.gridPane.add((Node)this.shortLabel, 0, 0);
                            this.gridPane.add((Node)this.longLabel, 1, 0);
                            this.gridPane.setHgap(20.0);
                        } else {
                            this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(ShortLongTextCellFactory.this.shortWidth, ShortLongTextCellFactory.this.shortWidth, ShortLongTextCellFactory.this.shortWidth)});
                            this.gridPane.add((Node)this.shortLabel, 0, 0);
                        }
                    } else {
                        if (this.lastShortWidth != ShortLongTextCellFactory.this.shortWidth) {
                            this.updateConstraints((ColumnConstraints)this.gridPane.getColumnConstraints().get(0), ShortLongTextCellFactory.this.shortWidth);
                            this.lastShortWidth = ShortLongTextCellFactory.this.shortWidth;
                        }
                        if (this.lastLongWidth != ShortLongTextCellFactory.this.longWidth) {
                            this.updateConstraints((ColumnConstraints)this.gridPane.getColumnConstraints().get(1), ShortLongTextCellFactory.this.longWidth);
                            this.lastLongWidth = ShortLongTextCellFactory.this.longWidth;
                        }
                    }
                    ShortLongTextCellFactory.this.updateLabels(item, this.shortLabel, this.longLabel);
                    this.setGraphic((Node)this.gridPane);
                }
            }

            private void updateConstraints(ColumnConstraints constraints, double width) {
                constraints.setMinWidth(width);
                constraints.setPrefWidth(width);
                constraints.setMaxWidth(width);
            }
        };
    }

    protected ShortLongText getShortLongText(T item) {
        return item instanceof ShortLongText ? (ShortLongText)item : null;
    }

    protected void updateLabels(T item, Label shortLabel, Label longLabel) {
        ShortLongText slItem = this.getShortLongText(item);
        if (slItem != null) {
            shortLabel.setText(slItem.getShortText());
            longLabel.setText(slItem.getLongText());
        } else {
            shortLabel.setText(item.toString());
            longLabel.setText("");
        }
    }

    private void computeWidths(Font font, List<T> items) {
        Text text = new Text();
        text.setFont(font);
        this.shortWidth = 0.0;
        this.longWidth = 0.0;
        for (T item : items) {
            ShortLongText slItem = this.getShortLongText(item);
            if (slItem != null) {
                text.setText(slItem.getShortText());
                this.shortWidth = Double.max(this.shortWidth, text.getLayoutBounds().getWidth());
                text.setText(slItem.getLongText());
                this.longWidth = Double.max(this.longWidth, text.getLayoutBounds().getWidth());
                continue;
            }
            text.setText(item.toString());
            this.shortWidth = Double.max(this.shortWidth, text.getLayoutBounds().getWidth());
        }
    }
}

