/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.function.Function;
import org.tentackle.fx.FxComponent;

public interface ValueTranslator<M, V> {
    public FxComponent getComponent();

    public Function<M, V> toViewFunction();

    public Function<V, M> toModelFunction();

    public boolean isLenient();

    public boolean isMappingIncomplete();

    public void saveModelValue(M var1);

    public boolean isModelModified();

    default public boolean needsToModelTwice() {
        return false;
    }

    default public void bindingPropertiesUpdated() {
    }

    default public V toView(M value) {
        return this.toViewFunction().apply(value);
    }

    default public M toModel(V value) {
        return this.toModelFunction().apply(value);
    }
}

