/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.bind;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.bind.AbstractBindingFactory;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.Service;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxController;
import org.tentackle.fx.bind.DefaultFxComponentBinder;
import org.tentackle.fx.bind.DefaultFxComponentBinding;
import org.tentackle.fx.bind.DefaultFxTableBinder;
import org.tentackle.fx.bind.DefaultFxTableBinding;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxComponentBinder;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.bind.FxTableBinder;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.log.Logger;

@Service(value=FxBindingFactory.class)
public class DefaultFxBindingFactory
extends AbstractBindingFactory
implements FxBindingFactory {
    private static final Logger LOGGER = Logger.get(DefaultFxBindingFactory.class);
    private final Map<Class<? extends FxComponent>, Class<? extends FxComponentBinding>> componentClassMap = new ConcurrentHashMap<Class<? extends FxComponent>, Class<? extends FxComponentBinding>>();
    private final Map<Class<? extends FxComponent>, Class<? extends FxComponentBinding>> allComponentClassMap = new ConcurrentHashMap<Class<? extends FxComponent>, Class<? extends FxComponentBinding>>();

    @Override
    public Class<? extends FxComponentBinding> setComponentBindingClass(Class<? extends FxComponent> componentClass, Class<? extends FxComponentBinding> bindingClass) {
        return this.componentClassMap.put(componentClass, bindingClass);
    }

    @Override
    public Class<? extends FxComponentBinding> getComponentBindingClass(Class<? extends FxComponent> componentClass) {
        Class<? extends FxComponentBinding> bindingClass = this.allComponentClassMap.get(componentClass);
        if (bindingClass == null) {
            Class<? extends FxComponent> clazz = componentClass;
            while (FxComponent.class.isAssignableFrom(clazz) && (bindingClass = this.componentClassMap.get(clazz)) == null) {
                clazz = clazz.getSuperclass();
            }
            this.allComponentClassMap.put(componentClass, bindingClass == null ? FxComponentBinding.class : bindingClass);
        } else if (bindingClass == FxComponentBinding.class) {
            bindingClass = null;
        }
        return bindingClass;
    }

    @Override
    public FxComponentBinding createComponentBinding(FxComponentBinder binder, BindingMember[] parents, BindingMember member, FxComponent component, String componentOptions) {
        FxComponentBinding binding;
        Class<? extends FxComponentBinding> bindingClass = this.getComponentBindingClass(component.getClass());
        if (bindingClass != null) {
            try {
                Constructor<? extends FxComponentBinding> con = bindingClass.getConstructor(FxComponentBinder.class, BindingMember[].class, BindingMember.class, FxComponent.class, String.class);
                binding = con.newInstance(binder, parents, member, component, componentOptions);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new BindingException("could not instantiate binding " + bindingClass.getName(), (Throwable)ex);
            }
        } else {
            binding = new DefaultFxComponentBinding(binder, parents, member, component, componentOptions);
        }
        LOGGER.fine("created component binding {0}", new Object[]{binding});
        return binding;
    }

    @Override
    public FxComponentBinder createComponentBinder(FxController controller) {
        return new DefaultFxComponentBinder(controller);
    }

    @Override
    public <S, T> FxTableBinding<S, T> createTableBinding(FxTableBinder<S> binder, BindingMember[] parents, BindingMember member, TableColumnConfiguration<S, T> columnConfig, String columnOptions) {
        DefaultFxTableBinding<S, T> binding = new DefaultFxTableBinding<S, T>(binder, parents, member, columnConfig, columnOptions);
        columnConfig.setBinding(binding);
        return binding;
    }

    @Override
    public <S> FxTableBinder<S> createTableBinder(TableConfiguration<S> tableConfiguration) {
        return new DefaultFxTableBinder<S>(tableConfiguration);
    }
}

