/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.bind;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javafx.scene.Parent;
import org.tentackle.bind.AbstractBinder;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxController;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxComponentBinder;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.log.Logger;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationContextFactory;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;
import org.tentackle.validate.scope.MandatoryScope;

public class DefaultFxComponentBinder
extends AbstractBinder
implements FxComponentBinder {
    public static String[] bindingPathSuffixes = new String[]{"Field", "Node", "Comp", "Component", "Control"};
    private static final Logger LOGGER = Logger.get(DefaultFxComponentBinder.class);
    private final FxController controller;
    private final TreeMap<String, FxComponent> eligibleComponents;
    private final Map<FxComponent, FxComponentBinding> boundComponents;
    private final Set<FxComponent> unboundComponents;
    private final Map<String, FxComponentBinding> boundPaths;
    private final List<Binding> dynamicMandatoryBindings;
    private boolean needMandatoryUpdate;
    private final List<Binding> dynamicChangeableBindings;
    private boolean needChangeableUpdate;

    public DefaultFxComponentBinder(FxController controller) {
        this.controller = controller;
        this.eligibleComponents = new TreeMap();
        this.boundComponents = new HashMap<FxComponent, FxComponentBinding>();
        this.unboundComponents = new HashSet<FxComponent>();
        this.boundPaths = new TreeMap<String, FxComponentBinding>();
        this.dynamicMandatoryBindings = new ArrayList<Binding>();
        this.dynamicChangeableBindings = new ArrayList<Binding>();
    }

    @Override
    public FxController getController() {
        return this.controller;
    }

    public void fireToView(Binding binding, Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        MandatoryScope scope;
        Object parentObject;
        super.fireToView(binding, parent, modelValue);
        if (this.needMandatoryUpdate) {
            for (Binding mandatoryBinding : this.dynamicMandatoryBindings) {
                boolean mandatory = false;
                for (Validator validator : mandatoryBinding.getValidators()) {
                    if (!(validator instanceof MandatoryBindingEvaluator) || (parentObject = mandatoryBinding.getParentObject()) == null || !(scope = ValidationScopeFactory.getInstance().getMandatoryScope()).appliesTo(validator.getConfiguredScopes(validationContext = ValidationContextFactory.getInstance().create(mandatoryBinding.getMember().getMemberPath(), mandatoryBinding.getMember().getType(), mandatoryBinding.getModelValue(), parentObject, (ValidationScope)scope, null))) || !((MandatoryBindingEvaluator)validator).isMandatory(validationContext)) continue;
                    mandatory = true;
                    break;
                }
                mandatoryBinding.setMandatory(mandatory);
            }
            this.needMandatoryUpdate = false;
        }
        if (this.needChangeableUpdate) {
            for (Binding changeableBinding : this.dynamicChangeableBindings) {
                boolean changeable = false;
                for (Validator validator : changeableBinding.getValidators()) {
                    if (!(validator instanceof ChangeableBindingEvaluator) || (parentObject = changeableBinding.getParentObject()) == null || !(scope = ValidationScopeFactory.getInstance().getChangeableScope()).appliesTo(validator.getConfiguredScopes(validationContext = ValidationContextFactory.getInstance().create(changeableBinding.getMember().getMemberPath(), changeableBinding.getMember().getType(), changeableBinding.getModelValue(), parentObject, (ValidationScope)scope, null))) || !((ChangeableBindingEvaluator)validator).isChangeable(validationContext)) continue;
                    changeable = true;
                    break;
                }
                changeableBinding.setChangeable(changeable);
            }
            this.needChangeableUpdate = false;
        }
    }

    public void fireToModel(Binding binding, Object parent, Object viewValue) throws BindingVetoException {
        super.fireToModel(binding, parent, viewValue);
        this.requestMandatoryUpdate();
        this.requestChangeableUpdate();
    }

    @Override
    public void requestMandatoryUpdate() {
        this.needMandatoryUpdate = true;
    }

    @Override
    public List<? extends Binding> getMandatoryBindings() {
        return this.dynamicMandatoryBindings;
    }

    @Override
    public void requestChangeableUpdate() {
        this.needChangeableUpdate = true;
    }

    @Override
    public List<? extends Binding> getChangeableBindings() {
        return this.dynamicChangeableBindings;
    }

    public int bindAllInherited() {
        int count = this.doBind(true, true);
        if (this.isUnboundPending()) {
            count += this.doBind(false, false);
        }
        return count;
    }

    @Override
    public int bindWithInheritedBindables() {
        int count = this.doBind(true, true);
        if (this.isUnboundPending()) {
            count += this.doBind(false, true);
        }
        return count;
    }

    @Override
    public int bindWithInheritedComponents() {
        int count = this.doBind(true, true);
        if (this.isUnboundPending()) {
            count += this.doBind(true, false);
        }
        return count;
    }

    public int bind() {
        return this.doBind(true, true);
    }

    public void unbind() {
        for (FxComponent comp : this.boundComponents.keySet()) {
            comp.setBinding(null);
        }
        this.eligibleComponents.clear();
        this.unboundComponents.clear();
        this.boundComponents.clear();
        this.boundPaths.clear();
    }

    public Collection<FxComponentBinding> getBindings() {
        return this.boundComponents.values();
    }

    @Override
    public Collection<FxComponent> getBoundComponents() {
        return this.boundComponents.keySet();
    }

    @Override
    public Collection<FxComponent> getUnboundComponents() {
        return this.unboundComponents;
    }

    public boolean isUnboundPending() {
        return !this.unboundComponents.isEmpty();
    }

    public void assertAllBound() {
        if (this.isUnboundPending()) {
            StringBuilder buf = new StringBuilder();
            for (FxComponent comp : this.eligibleComponents.values()) {
                if (comp.getBinding() != null) continue;
                if (!buf.isEmpty()) {
                    buf.append(", ");
                }
                buf.append(comp.getComponentPath());
            }
            throw new BindingException("unbound components in " + this.controller.getClass().getSimpleName() + ": " + buf);
        }
    }

    public void addBinding(Binding binding) {
        if (binding instanceof FxComponentBinding) {
            FxComponentBinding oldBinding = this.boundPaths.put(binding.getMember().getMemberPath(), (FxComponentBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": binding path '" + binding.getMember().getMemberPath() + "' already bound to " + oldBinding.getComponent().getComponentPath());
            }
            oldBinding = this.boundComponents.put(((FxComponentBinding)binding).getComponent(), (FxComponentBinding)binding);
            if (oldBinding != null) {
                throw new BindingException(binding + ": component '" + ((FxComponentBinding)binding).getComponent().getComponentPath() + "' already bound to " + oldBinding.getMember().getMemberPath());
            }
            this.unboundComponents.remove(((FxComponentBinding)binding).getComponent());
            List validators = binding.getValidators();
            if (validators != null) {
                for (Validator validator : validators) {
                    if (validator instanceof MandatoryBindingEvaluator && ((MandatoryBindingEvaluator)validator).isMandatoryDynamic()) {
                        this.addMandatoryBinding(binding);
                        this.requestMandatoryUpdate();
                    }
                    if (!(validator instanceof ChangeableBindingEvaluator) || !((ChangeableBindingEvaluator)validator).isChangeableDynamic()) continue;
                    this.addChangeableBinding(binding);
                    this.requestChangeableUpdate();
                }
            }
        }
    }

    @Override
    public FxComponentBinding getBinding(FxComponent component) {
        return this.boundComponents.get(component);
    }

    @Override
    public FxComponentBinding getBinding(String bindingPath) {
        return this.boundPaths.get(bindingPath);
    }

    @Override
    public FxComponentBinding removeBinding(FxComponent component) {
        FxComponentBinding binding = this.boundComponents.remove(component);
        if (binding != null) {
            if (this.boundPaths.remove(binding.getMember().getMemberPath()) != binding) {
                throw new BindingException("Binding " + binding + " missing in path map");
            }
            binding.getComponent().setBinding(null);
        }
        return binding;
    }

    @Override
    public FxComponentBinding removeBinding(String bindingPath) {
        FxComponentBinding binding = this.boundPaths.remove(bindingPath);
        if (binding != null) {
            if (this.boundComponents.remove(binding.getComponent()) != binding) {
                throw new BindingException("Binding " + binding + " missing in component map");
            }
            binding.getComponent().setBinding(null);
        }
        return binding;
    }

    protected void addMandatoryBinding(Binding mandatoryBinding) {
        this.dynamicMandatoryBindings.add(mandatoryBinding);
    }

    protected void addChangeableBinding(Binding changeableBinding) {
        this.dynamicChangeableBindings.add(changeableBinding);
    }

    protected int doBind(BindingMember[] parents, String parentMemberPath, Class<?> parentClass, boolean declaredOnly) {
        if (parentMemberPath != null) {
            boolean found = false;
            for (String bindingPath : this.toCamelCase(parentMemberPath)) {
                String key;
                found = this.eligibleComponents.containsKey(bindingPath);
                if (!found && (key = this.eligibleComponents.higherKey(bindingPath)) != null && key.startsWith(bindingPath)) {
                    found = true;
                }
                if (found) break;
            }
            if (!found) {
                return 0;
            }
        }
        int count = 0;
        for (BindableElement element : FxBindingFactory.getInstance().getBindableCache().getBindableMap(parentClass, declaredOnly)) {
            String fieldMemberName = StringHelper.firstToLower((String)element.getCamelName());
            String fieldMemberPath = (String)(parentMemberPath == null ? "" : parentMemberPath + ".") + fieldMemberName;
            BindingMember[] fieldParents = new BindingMember[parents == null ? 1 : parents.length + 1];
            BindingMember fieldMember = FxBindingFactory.getInstance().createBindingMember(parentClass, parents == null ? null : parents[parents.length - 1], fieldMemberName, fieldMemberPath, element);
            if (parents != null) {
                System.arraycopy(parents, 0, fieldParents, 0, parents.length);
                fieldParents[parents.length] = fieldMember;
            } else {
                fieldParents[0] = fieldMember;
            }
            try {
                FxComponent component = this.findComponent(fieldMemberPath);
                if (component != null && component.getBinding() == null) {
                    FxComponentBinding binding = FxBindingFactory.getInstance().createComponentBinding(this, parents, fieldMember, component, element.getBindingOptions());
                    this.addBinding(binding);
                    ++count;
                }
                count += this.doBind(fieldParents, fieldMemberPath, fieldMember.getType(), declaredOnly);
            }
            catch (RuntimeException ex) {
                throw new BindingException("binding " + fieldMemberPath + " failed", (Throwable)ex);
            }
        }
        return count;
    }

    private String[] toCamelCase(String bindingPath) {
        StringTokenizer stok = new StringTokenizer(bindingPath, ".");
        StringBuilder buf = new StringBuilder();
        StringBuilder omitBuf = new StringBuilder();
        int omitCount = 0;
        String lastCamelName = null;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (buf.isEmpty()) {
                buf.append(token);
                if (omitCount >= 0) {
                    omitBuf.append(token);
                    ++omitCount;
                }
            } else {
                token = StringHelper.firstToUpper((String)token);
                buf.append(token);
                if (omitCount >= 0) {
                    if (lastCamelName == null) {
                        omitBuf.append(token);
                        ++omitCount;
                    } else if (token.toLowerCase(Locale.ROOT).startsWith(lastCamelName)) {
                        omitBuf.append(token.substring(lastCamelName.length()));
                        ++omitCount;
                    } else {
                        omitCount = -1;
                    }
                }
            }
            lastCamelName = token.toLowerCase(Locale.ROOT);
        }
        if (omitCount > 1 && omitCount < 4) {
            return new String[]{buf.toString(), omitBuf.toString()};
        }
        return new String[]{buf.toString()};
    }

    private FxComponent findComponent(String bindingPath) {
        FxComponent comp = null;
        for (String path : this.toCamelCase(bindingPath)) {
            LOGGER.finer("checking {0} for matching component", new Object[]{path});
            comp = this.eligibleComponents.get(path);
            if (comp != null) break;
        }
        return comp;
    }

    private FxComponent getFxComponent(FxController controller, Field field) {
        FxComponent component;
        block5: {
            component = null;
            try {
                if (!FxComponent.class.isAssignableFrom(field.getType())) break block5;
                try {
                    component = (FxComponent)field.get(controller);
                }
                catch (IllegalAccessException ex) {
                    field.setAccessible(true);
                    component = (FxComponent)field.get(controller);
                }
                if (component == null) {
                    throw new BindingException(field + " is null");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new BindingException("cannot access " + field, (Throwable)ex);
            }
        }
        return component;
    }

    private void addEligibleComponents(FxController controller, String controllerPath, Set<FxController> checkedControllers, boolean declaredOnly) {
        Parent view = controller.getView();
        if (view instanceof FxContainer && ((FxContainer)view).isBindable() && checkedControllers.add(controller)) {
            LOGGER.finer("checking {0} for eligible components", new Object[]{controllerPath});
            for (Field field : declaredOnly ? controller.getClass().getDeclaredFields() : ReflectionHelper.getAllFields(controller.getClass(), (Class[])new Class[]{FxController.class}, (boolean)false, null, (boolean)true)) {
                FxComponent component = this.getFxComponent(controller, field);
                if (component == null || !component.isBindable() || component.getBinding() != null) continue;
                String componentPath = controllerPath + "." + field.getName();
                component.setComponentPath(componentPath);
                String bindingPath = component.getBindingPath();
                if (bindingPath == null) {
                    String anotherBindingPath;
                    bindingPath = field.getName();
                    String componentClassName = component.getClass().getSimpleName();
                    if (componentClassName.startsWith("Fx")) {
                        componentClassName = componentClassName.substring(2);
                    }
                    if (!bindingPath.equals(anotherBindingPath = StringHelper.removeTrailingText((String)bindingPath, (String[])new String[]{componentClassName}))) {
                        this.addToEligibleComponents(anotherBindingPath, component);
                    }
                    if (componentClassName.endsWith("View") && !bindingPath.equals(anotherBindingPath = StringHelper.removeTrailingText((String)bindingPath, (String[])new String[]{componentClassName = componentClassName.substring(0, componentClassName.length() - 4)}))) {
                        this.addToEligibleComponents(anotherBindingPath, component);
                    }
                    if (!bindingPath.equals(anotherBindingPath = StringHelper.removeTrailingText((String)bindingPath, (String[])bindingPathSuffixes))) {
                        this.addToEligibleComponents(anotherBindingPath, component);
                    }
                }
                this.addToEligibleComponents(bindingPath, component);
            }
        }
    }

    private void addToEligibleComponents(String bindingPath, FxComponent component) {
        FxComponent oldComponent = this.eligibleComponents.put(bindingPath, component);
        if (oldComponent != null) {
            if (oldComponent != component) {
                throw new BindingException("binding path '" + bindingPath + "' already provided by " + oldComponent.getComponentPath());
            }
        } else {
            LOGGER.finer("added {0}:{1} to eligible components", new Object[]{component.getComponentPath(), bindingPath});
            this.unboundComponents.add(component);
        }
    }

    private int doBind(boolean declaredBindablesOnly, boolean declaredComponentsOnly) {
        this.addEligibleComponents(this.controller, this.controller.getClass().getName(), new HashSet<FxController>(), declaredComponentsOnly);
        LOGGER.fine(() -> {
            StringBuilder buf = new StringBuilder();
            buf.append("--------- eligible components: ----------\n");
            for (Map.Entry<String, FxComponent> entry : this.eligibleComponents.entrySet()) {
                buf.append(entry.getKey());
                buf.append(" : ");
                buf.append(entry.getValue().getComponentPath());
                buf.append("\n");
            }
            buf.append("-----------------------------------------\n");
            return buf.toString();
        });
        return this.doBind(null, null, this.controller.getClass(), declaredBindablesOnly);
    }
}

