/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.bind;

import java.util.ArrayList;
import java.util.List;
import org.tentackle.bind.AbstractBinding;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.bind.FxTableBinder;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationContextFactory;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;
import org.tentackle.validate.scope.MandatoryScope;

public class DefaultFxTableBinding<S, T>
extends AbstractBinding
implements FxTableBinding<S, T> {
    private final TableColumnConfiguration<S, T> columnConfiguration;
    private boolean mandatory;
    private boolean changeable;
    private List<Validator> mandatoryValidators;
    private List<Validator> changeableValidators;
    private S rowObject;

    public DefaultFxTableBinding(FxTableBinder<S> binder, BindingMember[] parents, BindingMember member, TableColumnConfiguration<S, T> columnConfiguration, String columnOptions) {
        super(binder, parents, member);
        this.columnConfiguration = columnConfiguration;
        FxUtilities.getInstance().applyBindingOptions(columnConfiguration, member, columnOptions);
        this.applyType();
        this.determineValidators();
    }

    @Override
    public FxTableBinder<S> getBinder() {
        return (FxTableBinder)super.getBinder();
    }

    @Override
    public T getModelValue() {
        return (T)super.getModelValue();
    }

    protected void applyType() {
        this.columnConfiguration.setGenericType(this.getMember().getGenericType());
        this.columnConfiguration.setType(this.getMember().getType());
    }

    protected Class<?> getViewType() {
        return this.columnConfiguration.getType();
    }

    protected void determineValidators() {
        super.determineValidators();
        List validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                if (validator instanceof MandatoryBindingEvaluator) {
                    if (this.mandatoryValidators == null) {
                        this.mandatoryValidators = new ArrayList<Validator>();
                    }
                    this.mandatoryValidators.add(validator);
                }
                if (!(validator instanceof ChangeableBindingEvaluator)) continue;
                if (this.changeableValidators == null) {
                    this.changeableValidators = new ArrayList<Validator>();
                }
                this.changeableValidators.add(validator);
            }
        }
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setChangeable(boolean changeable) {
        this.changeable = changeable;
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void fireToView(Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        MandatoryScope scope;
        if (this.mandatoryValidators != null && !this.mandatoryValidators.isEmpty()) {
            boolean cellIsMandatory = false;
            for (Validator validator : this.mandatoryValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getMandatoryScope()).appliesTo(validator.getConfiguredScopes(validationContext = ValidationContextFactory.getInstance().create(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope, null))) || !validator.isConditionValid(validationContext) || !((MandatoryBindingEvaluator)validator).isMandatory(validationContext)) continue;
                cellIsMandatory = true;
                break;
            }
            this.setMandatory(cellIsMandatory);
        }
        if (this.changeableValidators != null && !this.changeableValidators.isEmpty()) {
            boolean cellIsChangeable = false;
            for (Validator validator : this.changeableValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getChangeableScope()).appliesTo(validator.getConfiguredScopes(validationContext = ValidationContextFactory.getInstance().create(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope, null))) || !validator.isConditionValid(validationContext) || !((ChangeableBindingEvaluator)validator).isChangeable(validationContext)) continue;
                cellIsChangeable = true;
                break;
            }
            this.setChangeable(cellIsChangeable);
        }
        super.fireToView(parent, modelValue);
    }

    protected boolean isValidationRequired() {
        return true;
    }

    protected String viewComponentToString() {
        return this.getMember() + ":" + this.columnConfiguration.getName();
    }

    public Object getViewValue() {
        return null;
    }

    protected void updateView(Object value) {
    }

    @Override
    public void setBoundRootObject(S rowObject) {
        this.rowObject = rowObject;
    }

    @Override
    public S getBoundRootObject() {
        return this.rowObject;
    }

    @Override
    public TableColumnConfiguration<S, T> getConfiguration() {
        return this.columnConfiguration;
    }
}

