/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ModelToViewListener;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.ViewToModelListener;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.component.Note;
import org.tentackle.fx.component.delegate.FxTableViewDelegate;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableConfiguration;

public class FxTableView<S>
extends TableView<S>
implements FxComponent {
    private TableConfiguration<S> configuration;
    private List<Note> infoNotes;
    private boolean copyToClipboardEnabled;
    private FxTableViewDelegate delegate;

    public TableConfiguration<S> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TableConfiguration<S> configuration) {
        this.configuration = configuration;
    }

    public void configure() {
        if (this.configuration == null) {
            throw new FxRuntimeException("missing table configuration");
        }
        this.configuration.configure(this);
    }

    public void scrollToCentered(int row) {
        this.scrollTo(FxUtilities.getInstance().computeScrollToCentered((Skinnable)this, row, this.getItems().size()));
    }

    public void scrollToCentered(S object) {
        int row;
        if (this.getItems() != null && (row = this.getItems().indexOf(object)) >= 0) {
            this.scrollToCentered(row);
        }
    }

    public void savePreferences(String suffix, boolean system) {
        if (this.configuration != null) {
            this.configuration.savePreferences(this, suffix, system);
        }
    }

    public void loadPreferences(String suffix, boolean system) {
        if (this.configuration != null) {
            this.configuration.loadPreferences(this, suffix, system);
        }
    }

    public void setSortable(boolean sortable) {
        for (TableColumn col : this.getColumns()) {
            col.setSortable(sortable);
        }
    }

    public void setReorderable(boolean reorderable) {
        for (TableColumn col : this.getColumns()) {
            col.setReorderable(reorderable);
        }
    }

    public void setCopyToClipboardEnabled(boolean copyToClipboardEnabled) {
        this.copyToClipboardEnabled = copyToClipboardEnabled;
    }

    public boolean isCopyToClipboardEnabled() {
        return this.copyToClipboardEnabled;
    }

    public String copyToClipboard(boolean swap) {
        ObservableList selectedCells = this.getSelectionModel().getSelectedCells();
        int rowMin = Integer.MAX_VALUE;
        int rowMax = Integer.MIN_VALUE;
        int colMin = Integer.MAX_VALUE;
        int colMax = Integer.MIN_VALUE;
        for (TablePosition pos : selectedCells) {
            int row = pos.getRow();
            int col = pos.getColumn();
            if (row < 0 || col < 0) continue;
            rowMin = Math.min(rowMin, row);
            rowMax = Math.max(rowMax, row);
            colMin = Math.min(colMin, col);
            colMax = Math.max(colMax, col);
        }
        if (rowMin != Integer.MAX_VALUE) {
            String text;
            int col;
            int rowNum = rowMax + 1 - rowMin;
            int colNum = colMax + 1 - colMin;
            String[][] cells = new String[rowNum][colNum];
            for (TablePosition pos : selectedCells) {
                TableColumn tableColumn;
                Object item;
                int row = pos.getRow();
                col = pos.getColumn();
                if (row < 0 || col < 0 || (item = (tableColumn = this.getVisibleLeafColumn(col)).getCellData(row)) == null) continue;
                text = null;
                for (Node c : this.lookupAll(".table-cell")) {
                    TableCell tc = (TableCell)c;
                    if (tc.getItem() != item) continue;
                    text = tc.getText();
                    break;
                }
                if (text == null) {
                    text = item.toString();
                }
                cells[row - rowMin][col - colMin] = text;
            }
            StringBuilder buf = new StringBuilder();
            boolean needLine = false;
            String separator = FxUtilities.getInstance().getCsvSeparator();
            if (swap) {
                for (col = 0; col < colNum; ++col) {
                    if (needLine) {
                        buf.append('\n');
                    } else {
                        needLine = true;
                    }
                    boolean needSep = false;
                    for (int row = 0; row < rowNum; ++row) {
                        if (needSep) {
                            buf.append(separator);
                        } else {
                            needSep = true;
                        }
                        text = cells[row][col];
                        if (text == null) continue;
                        buf.append(text);
                    }
                }
            } else {
                for (int row = 0; row < rowNum; ++row) {
                    if (needLine) {
                        buf.append('\n');
                    } else {
                        needLine = true;
                    }
                    boolean needSep = false;
                    for (int col2 = 0; col2 < colNum; ++col2) {
                        if (needSep) {
                            buf.append(separator);
                        } else {
                            needSep = true;
                        }
                        text = cells[row][col2];
                        if (text == null) continue;
                        buf.append(text);
                    }
                }
            }
            if (!buf.isEmpty()) {
                ClipboardContent cbc = new ClipboardContent();
                String text2 = buf.toString();
                cbc.putString(text2);
                Clipboard.getSystemClipboard().setContent((Map)cbc);
                return text2;
            }
        }
        return null;
    }

    public void handleKeyEvent(KeyEvent event) {
        if (this.isCopyToClipboardEnabled()) {
            if (event.getEventType() == KeyEvent.KEY_PRESSED && event.isControlDown() && event.getCode() == KeyCode.C) {
                String text = this.copyToClipboard(event.isShiftDown());
                if (text != null) {
                    Note infoNote = (Note)((Object)Fx.create(Note.class));
                    infoNote.setText(text);
                    infoNote.show((Node)this);
                    if (this.infoNotes == null) {
                        this.infoNotes = new ArrayList<Note>();
                    }
                    this.infoNotes.add(infoNote);
                }
            } else if (event.getEventType() == KeyEvent.KEY_RELEASED && event.getCode() == KeyCode.CONTROL && this.infoNotes != null) {
                for (Note infoNote : this.infoNotes) {
                    infoNote.hide();
                }
                this.infoNotes = null;
            }
        }
    }

    protected FxTableViewDelegate createDelegate() {
        return new FxTableViewDelegate(this);
    }

    @Override
    public FxTableViewDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(this.createDelegate());
        }
        return this.delegate;
    }

    public void setDelegate(FxTableViewDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public FxContainer getParentContainer() {
        return this.getDelegate().getParentContainer();
    }

    @Override
    public void setValueTranslator(ValueTranslator<?, ?> valueTranslator) {
        this.getDelegate().setValueTranslator(valueTranslator);
    }

    @Override
    public ValueTranslator<?, ?> getValueTranslator() {
        return this.getDelegate().getValueTranslator();
    }

    @Override
    public void invalidateSavedView() {
        this.getDelegate().invalidateSavedView();
    }

    @Override
    public boolean isSavedViewObjectValid() {
        return this.getDelegate().isSavedViewObjectValid();
    }

    @Override
    public <V> V getViewValue() {
        return this.getDelegate().getViewValue();
    }

    @Override
    public void setViewValue(Object value) {
        this.getDelegate().setViewValue(value);
    }

    @Override
    public void setType(Class<?> type) {
        this.getDelegate().setType(type);
    }

    @Override
    public Class<?> getType() {
        return this.getDelegate().getType();
    }

    @Override
    public void setGenericType(Type type) {
        this.getDelegate().setGenericType(type);
    }

    @Override
    public Type getGenericType() {
        return this.getDelegate().getGenericType();
    }

    @Override
    public void updateView() {
        this.getDelegate().updateView();
    }

    @Override
    public void updateModel() {
        this.getDelegate().updateModel();
    }

    @Override
    public void addModelToViewListener(ModelToViewListener listener) {
        this.getDelegate().addModelToViewListener(listener);
    }

    @Override
    public void removeModelToViewListener(ModelToViewListener listener) {
        this.getDelegate().removeModelToViewListener(listener);
    }

    @Override
    public void addViewToModelListener(ViewToModelListener listener) {
        this.getDelegate().addViewToModelListener(listener);
    }

    @Override
    public void removeViewToModelListener(ViewToModelListener listener) {
        this.getDelegate().removeViewToModelListener(listener);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.getDelegate().setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.getDelegate().isMandatory();
    }

    @Override
    public BooleanProperty mandatoryProperty() {
        return this.getDelegate().mandatoryProperty();
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.getDelegate().setBindingPath(bindingPath);
    }

    @Override
    public String getBindingPath() {
        return this.getDelegate().getBindingPath();
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.getDelegate().setComponentPath(componentPath);
    }

    @Override
    public String getComponentPath() {
        return this.getDelegate().getComponentPath();
    }

    @Override
    public void setBinding(FxComponentBinding binding) {
        this.getDelegate().setBinding(binding);
    }

    @Override
    public FxComponentBinding getBinding() {
        return this.getDelegate().getBinding();
    }

    @Override
    public void setChangeable(boolean changeable) {
        this.getDelegate().setChangeable(changeable);
    }

    @Override
    public boolean isChangeable() {
        return this.getDelegate().isChangeable();
    }

    @Override
    public ReadOnlyBooleanProperty changeableProperty() {
        return this.getDelegate().changeableProperty();
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
        this.getDelegate().setContainerChangeable(containerChangeable);
    }

    @Override
    public void setContainerChangeableIgnored(boolean containerChangeableIgnored) {
        this.getDelegate().setContainerChangeableIgnored(containerChangeableIgnored);
    }

    @Override
    public boolean isContainerChangeableIgnored() {
        return this.getDelegate().isContainerChangeableIgnored();
    }

    @Override
    public void setViewModified(boolean viewModified) {
        this.getDelegate().setViewModified(viewModified);
    }

    @Override
    public boolean isViewModified() {
        return this.getDelegate().isViewModified();
    }

    @Override
    public BooleanProperty viewModifiedProperty() {
        return this.getDelegate().viewModifiedProperty();
    }

    @Override
    public void triggerViewModified() {
        this.getDelegate().triggerViewModified();
    }

    @Override
    public void saveView() {
        this.getDelegate().saveView();
    }

    @Override
    public Object getSavedViewObject() {
        return this.getDelegate().getSavedViewObject();
    }

    @Override
    public Object getViewObject() {
        return this.getDelegate().getViewObject();
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.getDelegate().setViewObject(viewObject);
    }

    @Override
    public void setBindable(boolean bindable) {
        this.getDelegate().setBindable(bindable);
    }

    @Override
    public boolean isBindable() {
        return this.getDelegate().isBindable();
    }

    @Override
    public void setHelpUrl(String helpUrl) {
        this.getDelegate().setHelpUrl(helpUrl);
    }

    @Override
    public String getHelpUrl() {
        return this.getDelegate().getHelpUrl();
    }

    @Override
    public void showHelp() {
        this.getDelegate().showHelp();
    }

    @Override
    public String toGenericString() {
        return this.getDelegate().toGenericString();
    }

    @Override
    public void setError(String error) {
        this.getDelegate().setError(error);
    }

    @Override
    public String getError() {
        return this.getDelegate().getError();
    }

    @Override
    public void setErrorTemporary(boolean errorTemporary) {
        this.getDelegate().setErrorTemporary(errorTemporary);
    }

    @Override
    public boolean isErrorTemporary() {
        return this.getDelegate().isErrorTemporary();
    }

    @Override
    public void showErrorPopup() {
        this.getDelegate().showErrorPopup();
    }

    @Override
    public void hideErrorPopup() {
        this.getDelegate().hideErrorPopup();
    }

    @Override
    public void setInfo(String info) {
        this.getDelegate().setInfo(info);
    }

    @Override
    public String getInfo() {
        return this.getDelegate().getInfo();
    }

    @Override
    public void showInfoPopup() {
        this.getDelegate().showInfoPopup();
    }

    @Override
    public void hideInfoPopup() {
        this.getDelegate().hideInfoPopup();
    }

    @Override
    public boolean isModelUpdated() {
        return this.getDelegate().isModelUpdated();
    }

    @Override
    public void setTableCell(FxTableCell<?, ?> tableCell) {
        this.getDelegate().setTableCell(tableCell);
    }

    @Override
    public FxTableCell<?, ?> getTableCell() {
        return this.getDelegate().getTableCell();
    }

    @Override
    public void setTreeTableCell(FxTreeTableCell<?, ?> treeTableCell) {
        this.getDelegate().setTreeTableCell(treeTableCell);
    }

    @Override
    public FxTreeTableCell<?, ?> getTreeTableCell() {
        return this.getDelegate().getTreeTableCell();
    }

    @Override
    public boolean isListenerSuppressedIfModelUnchanged() {
        return this.getDelegate().isListenerSuppressedIfModelUnchanged();
    }

    @Override
    public void setListenerSuppressedIfModelUnchanged(boolean listenerSuppressedIfModelUnchanged) {
        this.getDelegate().setListenerSuppressedIfModelUnchanged(listenerSuppressedIfModelUnchanged);
    }

    @Override
    public boolean isListenerSuppressedIfViewUnchanged() {
        return this.getDelegate().isListenerSuppressedIfViewUnchanged();
    }

    @Override
    public void setListenerSuppressedIfViewUnchanged(boolean listenerSuppressedIfViewUnchanged) {
        this.getDelegate().setListenerSuppressedIfViewUnchanged(listenerSuppressedIfViewUnchanged);
    }
}

