/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ModelToViewListener;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.ViewToModelListener;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.component.delegate.FxTreeViewDelegate;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;

public class FxTreeView<T>
extends TreeView<T>
implements FxComponent {
    private FxTreeViewDelegate delegate;

    public void filterDangerousKeys(KeyEvent event) {
        if (event.getCode() == KeyCode.MULTIPLY) {
            event.consume();
            if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                if (event.isShiftDown()) {
                    this.collapseAll();
                } else {
                    this.expandAll();
                }
            }
        }
    }

    public void expandAll() {
        FxUtilities.getInstance().expandAll(this.getRoot());
    }

    public void collapseAll() {
        if (this.isShowRoot()) {
            this.scrollTo(0);
            FxUtilities.getInstance().collapseAll(this.getRoot());
        } else {
            ObservableList children = this.getRoot().getChildren();
            if (children != null && !children.isEmpty()) {
                this.scrollTo(0);
                FxUtilities.getInstance().collapseAll(children);
            }
        }
    }

    public void scrollToCentered(int row) {
        this.scrollTo(FxUtilities.getInstance().computeScrollToCentered((Skinnable)this, row, this.getItems().size()));
    }

    public List<T> getItems() {
        ArrayList items = new ArrayList();
        if (this.isShowRoot()) {
            this.getItems(items, this.getRoot());
        } else {
            for (TreeItem treeItem : this.getRoot().getChildren()) {
                this.getItems(items, treeItem);
            }
        }
        return items;
    }

    private void getItems(List<T> items, TreeItem<T> treeItem) {
        if (treeItem != null) {
            items.add(treeItem.getValue());
            if (treeItem.isExpanded()) {
                for (TreeItem child : treeItem.getChildren()) {
                    this.getItems(items, child);
                }
            }
        }
    }

    public List<TreeItem<T>> getTreeItems() {
        ArrayList<TreeItem<T>> items = new ArrayList<TreeItem<T>>();
        if (this.isShowRoot()) {
            this.getTreeItems(items, this.getRoot());
        } else {
            for (TreeItem treeItem : this.getRoot().getChildren()) {
                this.getTreeItems(items, treeItem);
            }
        }
        return items;
    }

    private void getTreeItems(List<TreeItem<T>> items, TreeItem<T> treeItem) {
        if (treeItem != null) {
            items.add(treeItem);
            for (TreeItem child : treeItem.getChildren()) {
                this.getTreeItems(items, child);
            }
        }
    }

    public List<T> getSelectedItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (TreeItem treeItem : this.getSelectionModel().getSelectedItems()) {
            items.add(treeItem.getValue());
        }
        return items;
    }

    protected FxTreeViewDelegate createDelegate() {
        return new FxTreeViewDelegate(this);
    }

    @Override
    public FxTreeViewDelegate getDelegate() {
        if (this.delegate == null) {
            this.setDelegate(this.createDelegate());
        }
        return this.delegate;
    }

    public void setDelegate(FxTreeViewDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public FxContainer getParentContainer() {
        return this.getDelegate().getParentContainer();
    }

    @Override
    public void setValueTranslator(ValueTranslator<?, ?> valueTranslator) {
        this.getDelegate().setValueTranslator(valueTranslator);
    }

    @Override
    public ValueTranslator<?, ?> getValueTranslator() {
        return this.getDelegate().getValueTranslator();
    }

    @Override
    public void invalidateSavedView() {
        this.getDelegate().invalidateSavedView();
    }

    @Override
    public boolean isSavedViewObjectValid() {
        return this.getDelegate().isSavedViewObjectValid();
    }

    @Override
    public <V> V getViewValue() {
        return this.getDelegate().getViewValue();
    }

    @Override
    public void setViewValue(Object value) {
        this.getDelegate().setViewValue(value);
    }

    @Override
    public void setType(Class<?> type) {
        this.getDelegate().setType(type);
    }

    @Override
    public Class<?> getType() {
        return this.getDelegate().getType();
    }

    @Override
    public void setGenericType(Type type) {
        this.getDelegate().setGenericType(type);
    }

    @Override
    public Type getGenericType() {
        return this.getDelegate().getGenericType();
    }

    @Override
    public void updateView() {
        this.getDelegate().updateView();
    }

    @Override
    public void updateModel() {
        this.getDelegate().updateModel();
    }

    @Override
    public void addModelToViewListener(ModelToViewListener listener) {
        this.getDelegate().addModelToViewListener(listener);
    }

    @Override
    public void removeModelToViewListener(ModelToViewListener listener) {
        this.getDelegate().removeModelToViewListener(listener);
    }

    @Override
    public void addViewToModelListener(ViewToModelListener listener) {
        this.getDelegate().addViewToModelListener(listener);
    }

    @Override
    public void removeViewToModelListener(ViewToModelListener listener) {
        this.getDelegate().removeViewToModelListener(listener);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.getDelegate().setMandatory(mandatory);
    }

    @Override
    public boolean isMandatory() {
        return this.getDelegate().isMandatory();
    }

    @Override
    public BooleanProperty mandatoryProperty() {
        return this.getDelegate().mandatoryProperty();
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.getDelegate().setBindingPath(bindingPath);
    }

    @Override
    public String getBindingPath() {
        return this.getDelegate().getBindingPath();
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.getDelegate().setComponentPath(componentPath);
    }

    @Override
    public String getComponentPath() {
        return this.getDelegate().getComponentPath();
    }

    @Override
    public void setBinding(FxComponentBinding binding) {
        this.getDelegate().setBinding(binding);
    }

    @Override
    public FxComponentBinding getBinding() {
        return this.getDelegate().getBinding();
    }

    @Override
    public void setChangeable(boolean changeable) {
        this.getDelegate().setChangeable(changeable);
    }

    @Override
    public boolean isChangeable() {
        return this.getDelegate().isChangeable();
    }

    @Override
    public ReadOnlyBooleanProperty changeableProperty() {
        return this.getDelegate().changeableProperty();
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
        this.getDelegate().setContainerChangeable(containerChangeable);
    }

    @Override
    public void setContainerChangeableIgnored(boolean containerChangeableIgnored) {
        this.getDelegate().setContainerChangeableIgnored(containerChangeableIgnored);
    }

    @Override
    public boolean isContainerChangeableIgnored() {
        return this.getDelegate().isContainerChangeableIgnored();
    }

    @Override
    public void setViewModified(boolean viewModified) {
        this.getDelegate().setViewModified(viewModified);
    }

    @Override
    public boolean isViewModified() {
        return this.getDelegate().isViewModified();
    }

    @Override
    public BooleanProperty viewModifiedProperty() {
        return this.getDelegate().viewModifiedProperty();
    }

    @Override
    public void triggerViewModified() {
        this.getDelegate().triggerViewModified();
    }

    @Override
    public void saveView() {
        this.getDelegate().saveView();
    }

    @Override
    public Object getSavedViewObject() {
        return this.getDelegate().getSavedViewObject();
    }

    @Override
    public Object getViewObject() {
        return this.getDelegate().getViewObject();
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.getDelegate().setViewObject(viewObject);
    }

    @Override
    public void setBindable(boolean bindable) {
        this.getDelegate().setBindable(bindable);
    }

    @Override
    public boolean isBindable() {
        return this.getDelegate().isBindable();
    }

    @Override
    public void setHelpUrl(String helpUrl) {
        this.getDelegate().setHelpUrl(helpUrl);
    }

    @Override
    public String getHelpUrl() {
        return this.getDelegate().getHelpUrl();
    }

    @Override
    public void showHelp() {
        this.getDelegate().showHelp();
    }

    @Override
    public String toGenericString() {
        return this.getDelegate().toGenericString();
    }

    @Override
    public void setError(String error) {
        this.getDelegate().setError(error);
    }

    @Override
    public String getError() {
        return this.getDelegate().getError();
    }

    @Override
    public void setErrorTemporary(boolean errorTemporary) {
        this.getDelegate().setErrorTemporary(errorTemporary);
    }

    @Override
    public boolean isErrorTemporary() {
        return this.getDelegate().isErrorTemporary();
    }

    @Override
    public void showErrorPopup() {
        this.getDelegate().showErrorPopup();
    }

    @Override
    public void hideErrorPopup() {
        this.getDelegate().hideErrorPopup();
    }

    @Override
    public void setInfo(String info) {
        this.getDelegate().setInfo(info);
    }

    @Override
    public String getInfo() {
        return this.getDelegate().getInfo();
    }

    @Override
    public void showInfoPopup() {
        this.getDelegate().showInfoPopup();
    }

    @Override
    public void hideInfoPopup() {
        this.getDelegate().hideInfoPopup();
    }

    @Override
    public boolean isModelUpdated() {
        return this.getDelegate().isModelUpdated();
    }

    @Override
    public void setTableCell(FxTableCell<?, ?> tableCell) {
        this.getDelegate().setTableCell(tableCell);
    }

    @Override
    public FxTableCell<?, ?> getTableCell() {
        return this.getDelegate().getTableCell();
    }

    @Override
    public void setTreeTableCell(FxTreeTableCell<?, ?> treeTableCell) {
        this.getDelegate().setTreeTableCell(treeTableCell);
    }

    @Override
    public FxTreeTableCell<?, ?> getTreeTableCell() {
        return this.getDelegate().getTreeTableCell();
    }

    @Override
    public boolean isListenerSuppressedIfModelUnchanged() {
        return this.getDelegate().isListenerSuppressedIfModelUnchanged();
    }

    @Override
    public void setListenerSuppressedIfModelUnchanged(boolean listenerSuppressedIfModelUnchanged) {
        this.getDelegate().setListenerSuppressedIfModelUnchanged(listenerSuppressedIfModelUnchanged);
    }

    @Override
    public boolean isListenerSuppressedIfViewUnchanged() {
        return this.getDelegate().isListenerSuppressedIfViewUnchanged();
    }

    @Override
    public void setListenerSuppressedIfViewUnchanged(boolean listenerSuppressedIfViewUnchanged) {
        this.getDelegate().setListenerSuppressedIfViewUnchanged(listenerSuppressedIfViewUnchanged);
    }
}

