/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component;

import java.net.URL;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.tentackle.fx.Fx;
import org.tentackle.fx.component.skin.NoteSkin;

public class Note
extends PopupControl {
    private static final String CSS_NAME = "note.css";
    private final StackPane rootPane;
    private Position position = Position.CENTER;
    private Type type = Type.INFO;
    private Node contentNode;
    private ObjectProperty<Node> contentNodeProperty;
    private FadeEffect fadeEffect;

    public Note() {
        this.getStyleClass().add((Object)"note");
        this.rootPane = new StackPane();
        URL noteCSS = this.getCSS();
        if (noteCSS != null) {
            this.rootPane.getStylesheets().add((Object)noteCSS.toExternalForm());
        }
        this.getStyleClass().add((Object)this.type.getCssClass());
        this.getStyleClass().add((Object)this.position.getCssClass());
        this.contentNode = new Label("???");
    }

    public void setFadeEffect(long fadeIn, long pause, long fadeOut) {
        this.fadeEffect = new FadeEffect(fadeIn > 0L ? new Duration((double)fadeIn) : null, pause > 0L ? new Duration((double)pause) : null, fadeOut > 0L ? new Duration((double)fadeOut) : null);
    }

    public void clearFadeEffect() {
        this.fadeEffect = null;
    }

    public void setPosition(Position position) {
        if (this.position != position) {
            this.position = position;
            position.apply((List<String>)this.getStyleClass());
        }
    }

    public Position getPosition() {
        return this.position;
    }

    public void setType(Type type) {
        if (this.type != type) {
            this.type = type;
            type.apply((List<String>)this.getStyleClass());
        }
    }

    public Type getType() {
        return this.type;
    }

    public StackPane getRootPane() {
        return this.rootPane;
    }

    public ObjectProperty<Node> contentNodeProperty() {
        if (this.contentNodeProperty == null) {
            this.contentNodeProperty = new SimpleObjectProperty((Object)this, "contentNode");
        }
        return this.contentNodeProperty;
    }

    public Node getContentNode() {
        if (this.contentNodeProperty != null) {
            return (Node)this.contentNodeProperty.get();
        }
        return this.contentNode;
    }

    public void setContentNode(Node contentNode) {
        if (this.contentNodeProperty != null) {
            this.contentNodeProperty.set((Object)contentNode);
        } else {
            this.contentNode = contentNode;
        }
    }

    public void show(Node ownerNode) {
        if (ownerNode != null && Fx.getStage(ownerNode) != null) {
            if (this.fadeEffect != null) {
                this.fadeEffect.play();
            }
            super.show(ownerNode, 0.0, 0.0);
        }
    }

    public void setText(String text) {
        Label label = new Label(text);
        label.getStyleClass().add((Object)"text");
        this.setContentNode((Node)label);
    }

    public String getText() {
        String string;
        Node contentNode = this.getContentNode();
        if (contentNode instanceof Label) {
            Label label = (Label)contentNode;
            string = label.getText();
        } else {
            string = null;
        }
        return string;
    }

    protected Skin<?> createDefaultSkin() {
        return new NoteSkin(this);
    }

    protected URL getCSS() {
        return Note.class.getResource(CSS_NAME);
    }

    public static enum Position {
        RIGHT("right"),
        LEFT("left"),
        TOP("top"),
        BOTTOM("bottom"),
        CENTER("center");

        private final String cssClass;

        private Position(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void apply(List<String> styleClass) {
            for (Position position : Position.values()) {
                if (position == this) {
                    if (styleClass.contains(this.cssClass)) continue;
                    styleClass.add(this.cssClass);
                    continue;
                }
                styleClass.remove(position.cssClass);
            }
        }
    }

    public static enum Type {
        ERROR("error"),
        INFO("info"),
        STICKY("sticky");

        private final String cssClass;

        private Type(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void apply(List<String> styleClass) {
            for (Type type : Type.values()) {
                if (type == this) {
                    if (styleClass.contains(this.cssClass)) continue;
                    styleClass.add(this.cssClass);
                    continue;
                }
                styleClass.remove(type.cssClass);
            }
        }
    }

    private class FadeEffect {
        private final Duration fadeIn;
        private final Duration pause;
        private final Duration fadeOut;

        private FadeEffect(Duration fadeIn, Duration pause, Duration fadeOut) {
            this.fadeIn = fadeIn;
            this.pause = pause;
            this.fadeOut = fadeOut;
        }

        private void play() {
            SequentialTransition mainTransition = new SequentialTransition();
            if (this.fadeIn != null) {
                FadeTransition inTransition = new FadeTransition(this.fadeIn, (Node)Note.this.getRootPane());
                inTransition.setFromValue(0.0);
                inTransition.setToValue(1.0);
                mainTransition.getChildren().add((Object)inTransition);
            }
            if (this.pause != null) {
                mainTransition.getChildren().add((Object)new PauseTransition(this.pause));
            }
            if (this.fadeOut != null) {
                FadeTransition outTransition = new FadeTransition(this.fadeOut, (Node)Note.this.getRootPane());
                outTransition.setFromValue(1.0);
                outTransition.setToValue(0.0);
                mainTransition.getChildren().add((Object)outTransition);
            }
            mainTransition.setOnFinished(event -> Note.this.hide());
            mainTransition.play();
        }
    }
}

