/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.scene.control.ChoiceBox;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.ConfiguratorService;
import org.tentackle.fx.component.FxChoiceBox;
import org.tentackle.fx.component.config.ComponentConfigurator;
import org.tentackle.fx.component.config.PrefixSelectionFeature;

@ConfiguratorService(value=ChoiceBox.class)
public class ChoiceBoxConfigurator<T extends ChoiceBox<?>>
extends ComponentConfigurator<T> {
    @Override
    public void configure(T control) {
        super.configure(control);
        if (control instanceof FxChoiceBox) {
            FxChoiceBox choiceBox = (FxChoiceBox)control;
            choiceBox.setOnAction(e -> this.updateModelAndView(choiceBox));
            choiceBox.addEventFilter(KeyEvent.KEY_PRESSED, choiceBox::filterKeyPressed);
        }
        control.getProperties().put((Object)"prefixSelectionEnabled", (Object)"");
        new PrefixSelectionFeature<T>(control, () -> true, () -> control.getItems(), () -> control.getConverter(), index -> control.getSelectionModel().select(index.intValue())).configure();
    }
}

