/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.component.config.ComponentConfigurator;

public abstract class ComboBoxBaseConfigurator<T extends ComboBoxBase<?>>
extends ComponentConfigurator<T> {
    @Override
    public void configure(T control) {
        super.configure(control);
        if (control instanceof FxControl) {
            FxControl fxControl = (FxControl)control;
            control.setOnAction(e -> this.updateModelAndView(fxControl));
        }
    }

    @Override
    protected void filterKeys(T control) {
        super.filterKeys(control);
        if (control instanceof FxComponent) {
            control.addEventFilter(KeyEvent.ANY, event -> {
                if (!control.isEditable() && ((FxComponent)control).isCellEditor()) {
                    switch (event.getCode()) {
                        case PAGE_DOWN: 
                        case PAGE_UP: 
                        case HOME: 
                        case END: 
                        case LEFT: 
                        case RIGHT: {
                            event.consume();
                        }
                    }
                }
            });
        }
    }
}

