/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.event.Event;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.ConfiguratorService;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.config.TextInputControlConfigurator;

@ConfiguratorService(value=TextArea.class)
public class TextAreaConfigurator<T extends TextArea>
extends TextInputControlConfigurator<T> {
    private static final String NEXT = "to_next";
    private static final String PREVIOUS = "to_previous";

    @Override
    protected void remapKeys(T control) {
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.getCode() != KeyCode.TAB && event.getCode() != KeyCode.ENTER || event.isAltDown() || event.isMetaDown() || NEXT.equals(event.getText()) || PREVIOUS.equals(event.getText()) || control instanceof FxTextArea && !((FxTextArea)control).isNavigateViaEnterEnabled())) {
                if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                    if (event.isControlDown()) {
                        control.insertText(control.getCaretPosition(), event.getCode() == KeyCode.TAB ? "\t" : "\n");
                    } else if (event.getCode() == KeyCode.ENTER) {
                        if (event.isShiftDown()) {
                            this.focusPrevious(control);
                        } else {
                            this.focusNext(control);
                        }
                    }
                }
                event.consume();
            }
        });
    }

    @Override
    protected void focusNext(T control) {
        if (!(control instanceof FxComponent) || !((FxComponent)control).isCellEditor()) {
            KeyEvent event = new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, NEXT, KeyCode.TAB, false, true, false, false);
            control.fireEvent((Event)event);
        }
    }

    @Override
    protected void focusPrevious(T control) {
        if (!(control instanceof FxComponent) || !((FxComponent)control).isCellEditor()) {
            KeyEvent event = new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, PREVIOUS, KeyCode.TAB, true, false, false, false);
            control.fireEvent((Event)event);
        }
    }
}

