/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.event.Event;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.component.config.ComponentConfigurator;

public abstract class TextInputControlConfigurator<T extends TextInputControl>
extends ComponentConfigurator<T> {
    @Override
    public void configure(T control) {
        super.configure(control);
        control.textProperty().addListener(o -> ((FxComponent)control).triggerViewModified());
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.BACK_SPACE && event.isShiftDown() && !event.isControlDown() && !event.isAltDown() && !event.isMetaDown()) {
                if (event.getEventType() == KeyEvent.KEY_PRESSED && !control.isDisabled() && control.isEditable()) {
                    control.clear();
                }
                event.consume();
            }
        });
    }

    @Override
    protected void remapKeys(T control) {
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.getCode() != KeyCode.ENTER || event.isControlDown() || event.isAltDown() || event.isMetaDown() || event.getEventType() != KeyEvent.KEY_PRESSED)) {
                if (event.isShiftDown()) {
                    this.focusPrevious(control);
                } else {
                    this.focusNext(control);
                }
            }
        });
    }

    protected void focusNext(T control) {
        if (!(control instanceof FxComponent) || !((FxComponent)control).isCellEditor()) {
            KeyEvent event = new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, "", KeyCode.TAB, false, false, false, false);
            control.fireEvent((Event)event);
        }
    }

    protected void focusPrevious(T control) {
        if (!(control instanceof FxComponent) || !((FxComponent)control).isCellEditor()) {
            KeyEvent event = new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, "", KeyCode.TAB, true, false, false, false);
            control.fireEvent((Event)event);
        }
    }
}

