/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponentDelegate;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxDatePicker;
import org.tentackle.misc.ObjectUtilities;

public class FxDatePickerDelegate
extends FxTextComponentDelegate {
    private final FxDatePicker component;
    private String text;

    public FxDatePickerDelegate(FxDatePicker component) {
        this.component = component;
        component.setConverter(new DatePickerConverter());
        component.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)this));
    }

    @Override
    public FxDatePicker getComponent() {
        return this.component;
    }

    @Override
    public void setColumns(int columns) {
        this.component.getEditor().setPrefColumnCount(columns);
    }

    @Override
    public int getColumns() {
        return this.component.getEditor().getPrefColumnCount();
    }

    @Override
    public String getViewObject() {
        this.text = this.component.getEditor().getText();
        return StringHelper.isAllWhitespace((String)this.text) ? null : this.text;
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.text = (String)viewObject;
        this.component.getEditor().setText(this.text);
    }

    @Override
    public void setViewValue(Object value) {
        Pos alignment = this.component.getTextAlignment();
        if (alignment != null) {
            this.component.getEditor().setAlignment(alignment);
        }
        super.setViewValue(value);
    }

    @Override
    public void mapErrorOffsetToCaretPosition() {
        Integer errorOffset = this.getErrorOffset();
        if (errorOffset != null) {
            Platform.runLater(() -> {
                this.component.getEditor().deselect();
                this.component.getEditor().positionCaret(errorOffset.intValue());
            });
        }
    }

    @Override
    public void autoSelect() {
        if (this.isAutoSelect()) {
            this.component.getEditor().selectAll();
        } else {
            this.component.getEditor().deselect();
        }
    }

    @Override
    public void setType(Class<?> type) {
        if (!(Date.class.isAssignableFrom(type) && !Time.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type))) {
            throw new FxRuntimeException(type.getName() + " not applicable to " + this.component.getClass().getName());
        }
        super.setType(type);
    }

    @Override
    public Node getNode() {
        return this.component.getEditor();
    }

    private class DatePickerConverter
    extends StringConverter<LocalDate> {
        private LocalDate lastDate;

        private DatePickerConverter() {
        }

        public String toString(LocalDate object) {
            if (FxDatePickerDelegate.this.component.isChangeable()) {
                if (object != null) {
                    ValueTranslator<?, ?> translator = FxDatePickerDelegate.this.getValueTranslator();
                    Object modelValue = ObjectUtilities.getInstance().convert(FxDatePickerDelegate.this.component.getType(), (Object)object);
                    return (String)translator.toView(modelValue);
                }
                return null;
            }
            return FxDatePickerDelegate.this.text;
        }

        public LocalDate fromString(String value) {
            if (FxDatePickerDelegate.this.getError() == null) {
                ValueTranslator<?, ?> translator = FxDatePickerDelegate.this.getValueTranslator();
                Object modelValue = translator.toModel(value);
                this.lastDate = (LocalDate)ObjectUtilities.getInstance().convert(LocalDate.class, modelValue);
            }
            return this.lastDate;
        }
    }
}

