/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.geometry.Pos;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.component.delegate.AbstractTextFieldDelegate;

public class FxTextFieldDelegate
extends AbstractTextFieldDelegate<FxTextField> {
    private boolean setColumnsInvoked;

    public FxTextFieldDelegate(FxTextField component) {
        super(component);
    }

    @Override
    public String getViewObject() {
        String text = ((FxTextField)this.getComponent()).getText();
        return StringHelper.isAllWhitespace((String)text) ? null : text;
    }

    @Override
    public void setViewObject(Object viewObject) {
        ((FxTextField)this.getComponent()).setText((String)viewObject);
    }

    @Override
    public void setColumns(int columns) {
        ((FxTextField)this.getComponent()).setPrefColumnCount(columns);
        this.setColumnsInvoked = true;
    }

    @Override
    public int getColumns() {
        return ((FxTextField)this.getComponent()).getPrefColumnCount();
    }

    @Override
    public void setMaxColumns(int maxColumns) {
        super.setMaxColumns(maxColumns);
        if (!this.setColumnsInvoked) {
            ((FxTextField)this.getComponent()).setPrefColumnCount(maxColumns);
        }
    }

    @Override
    public void setViewValue(Object value) {
        super.setViewValue(value);
        Pos alignment = this.getTextAlignment();
        if (alignment != null && ((FxTextField)this.getComponent()).getAlignment() != alignment) {
            ((FxTextField)this.getComponent()).setAlignment(alignment);
        }
    }
}

