/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.misc.TrackedList;

public class FxTreeViewDelegate
extends FxComponentDelegate {
    private final FxTreeView<?> component;
    private TrackedList<?> modelList;

    public FxTreeViewDelegate(FxTreeView<?> component) {
        this.component = component;
    }

    @Override
    public FxTreeView<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(FxFactory.getInstance().createValueTranslator(type, TreeItem.class, this.getComponent()));
        }
    }

    public TreeItem getViewObject() {
        return this.component.getRoot();
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.component.setRoot((TreeItem)viewObject);
    }

    @Override
    public void setViewValue(Object value) {
        this.modelList = value instanceof TrackedList ? (TrackedList)value : null;
        super.setViewValue(value);
    }

    @Override
    public boolean isViewModified() {
        if (this.modelList != null) {
            return this.modelList.isModified();
        }
        return super.isViewModified();
    }

    @Override
    public void triggerViewModified() {
        if (this.getParentContainer() != null) {
            this.getParentContainer().triggerViewModified();
        }
    }

    @Override
    public void updateModel() {
    }

    @Override
    protected void updateChangeable(boolean changeable) {
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
    }
}

