/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTablePosition;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.table.TableCellType;
import org.tentackle.fx.table.TableColumnConfiguration;

public class FxTreeTableCell<S, T>
extends TreeTableCell<S, T> {
    private final TableColumnConfiguration<S, T> columnConfiguration;
    private boolean toNext;
    private boolean toPrevious;

    public FxTreeTableCell(TableColumnConfiguration<S, T> columnConfiguration) {
        this.columnConfiguration = columnConfiguration;
        this.setEditable(columnConfiguration.isEditable());
    }

    public TableColumnConfiguration<S, T> getColumnConfiguration() {
        return this.columnConfiguration;
    }

    protected void updateItem(T item, boolean empty) {
        if (item == this.getItem()) {
            return;
        }
        super.updateItem(item, empty);
        if (item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else if (item instanceof Node) {
            this.setText(null);
            this.setGraphic((Node)item);
        } else {
            this.getCellType().updateItem(this, item);
        }
    }

    protected TableCellType<T> getCellType() {
        TableCellType<T> cellType = this.columnConfiguration.getCellType();
        return cellType != null ? cellType : this.columnConfiguration.getTableConfiguration().getTableCellType(this.columnConfiguration.getType());
    }

    public void startEdit() {
        if (this.isEditable() && this.getTreeTableView().isEditable() && this.getTableColumn().isEditable()) {
            super.startEdit();
            if (this.isEditing()) {
                this.toNext = false;
                this.toPrevious = false;
                TableCellType<T> cellType = this.getCellType();
                FxComponent editor = this.getEditor(cellType);
                editor.setTreeTableCell(this);
                editor.setType(this.columnConfiguration.getType());
                ValueTranslator<?, ?> translator = FxFactory.getInstance().createValueTranslator(editor.getType(), cellType.getEditorType(), editor);
                Object viewObject = translator.toView(this.getItem());
                editor.setViewObject(viewObject);
                editor.getDelegate().setLastViewObject(viewObject);
                this.setText(null);
                this.setGraphic((Node)editor);
                Node node = editor.getDelegate().getNode();
                EventHandler handler = event -> {
                    switch (event.getCode()) {
                        case ESCAPE: {
                            this.cancelEdit();
                            this.getTreeTableView().refresh();
                            event.consume();
                            break;
                        }
                        case TAB: 
                        case ENTER: {
                            if (event.isShiftDown()) {
                                this.toPrevious = true;
                            } else {
                                this.toNext = true;
                            }
                            Object value = translator.toModel(editor.getViewObject());
                            this.columnConfiguration.getBinding().setModelValue(value);
                            this.commitEdit(value);
                            this.getTreeTableView().refresh();
                            event.consume();
                        }
                    }
                };
                node.setOnKeyPressed(handler);
                if (editor != node) {
                    ((Node)editor).setOnKeyPressed(handler);
                }
                Platform.runLater(() -> Platform.runLater(() -> Platform.runLater(() -> ((Node)node).requestFocus())));
            }
        }
    }

    protected FxComponent getEditor(TableCellType<T> cellType) {
        FxComponent editor = this.columnConfiguration.getEditor();
        if (editor == null) {
            editor = cellType.getEditor();
        }
        return editor;
    }

    public void commitEdit(T newValue) {
        super.commitEdit(newValue);
        Platform.runLater(() -> {
            switch (this.columnConfiguration.getTableConfiguration().getEditMode()) {
                case ROW: {
                    TreeTablePosition<S, ?> pos;
                    if (this.toNext) {
                        TreeTablePosition<S, ?> pos2;
                        do {
                            this.getTreeTableView().getSelectionModel().selectNext();
                        } while ((pos2 = this.getPosition()) != null && !pos2.getTableColumn().isEditable());
                        this.editCell();
                        break;
                    }
                    if (!this.toPrevious) break;
                    do {
                        this.getTreeTableView().getSelectionModel().selectPrevious();
                    } while ((pos = this.getPosition()) != null && !pos.getTableColumn().isEditable());
                    this.editCell();
                    break;
                }
                case COLUMN: {
                    if (this.toNext) {
                        this.getTreeTableView().getSelectionModel().selectBelowCell();
                        this.editCell();
                        break;
                    }
                    if (!this.toPrevious) break;
                    this.getTreeTableView().getSelectionModel().selectAboveCell();
                    this.editCell();
                }
            }
            this.getTreeTableView().requestFocus();
        });
    }

    protected TreeTablePosition<S, ?> getPosition() {
        ObservableList cells = this.getTreeTableView().getSelectionModel().getSelectedCells();
        return cells.isEmpty() ? null : (TreeTablePosition)cells.get(0);
    }

    protected void editCell() {
        TreeTablePosition<S, ?> pos = this.getPosition();
        if (pos != null) {
            Platform.runLater(() -> this.getTreeTableView().edit(pos.getRow(), pos.getTableColumn()));
        }
    }
}

