/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.type.AbstractTableCellType;

public abstract class AbstractDateTimeTableCellType<T>
extends AbstractTableCellType<T> {
    @Override
    public void updateItem(FxTableCell<?, T> tableCell, T item) {
        tableCell.setGraphic(null);
        tableCell.setText(this.formatItem(this.getFormatter(tableCell.getColumnConfiguration()), item));
        this.updateAlignment(tableCell, Pos.BASELINE_CENTER);
    }

    @Override
    public void updateItem(FxTreeTableCell<?, T> treeTableCell, T item) {
        treeTableCell.setGraphic(null);
        treeTableCell.setText(this.formatItem(this.getFormatter(treeTableCell.getColumnConfiguration()), item));
        this.updateAlignment(treeTableCell, Pos.BASELINE_CENTER);
    }

    protected DateTimeFormatter getFormatter(TableColumnConfiguration<?, T> config) {
        return config.getDateTimeFormatter();
    }

    protected abstract String formatItem(DateTimeFormatter var1, T var2);
}

