/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import javafx.geometry.Pos;
import javafx.scene.control.CheckBox;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;

@TableCellTypeService(value=Boolean.class)
public class BooleanTableCellType
extends AbstractTableCellType<Boolean> {
    @Override
    public void updateItem(FxTableCell<?, Boolean> tableCell, Boolean item) {
        tableCell.setText(null);
        if (item.booleanValue()) {
            tableCell.setGraphic(Fx.createGraphic("checked"));
        } else {
            tableCell.setGraphic(Fx.createGraphic("unchecked"));
        }
        this.updateAlignment(tableCell, Pos.BASELINE_CENTER);
    }

    @Override
    public void updateItem(FxTreeTableCell<?, Boolean> tableCell, Boolean item) {
        tableCell.setText(null);
        if (item.booleanValue()) {
            tableCell.setGraphic(Fx.createGraphic("checked"));
        } else {
            tableCell.setGraphic(Fx.createGraphic("unchecked"));
        }
        this.updateAlignment(tableCell, Pos.BASELINE_CENTER);
    }

    @Override
    public FxComponent getEditor() {
        if (this.editor == null) {
            this.editor = (FxComponent)Fx.create(CheckBox.class);
        }
        return this.editor;
    }

    @Override
    public Class<?> getEditorType() {
        return Boolean.class;
    }
}

