/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractDateTimeTableCellType;
import org.tentackle.misc.FormatHelper;

@TableCellTypeService(value=Date.class)
public class DateTableCellType<T extends Date>
extends AbstractDateTimeTableCellType<T> {
    @Override
    protected String formatItem(DateTimeFormatter fmt, T item) {
        String text;
        if (fmt != null) {
            if (item instanceof java.sql.Date) {
                java.sql.Date date = (java.sql.Date)item;
                text = fmt.format(date.toLocalDate());
            } else {
                text = fmt.format(new java.sql.Date(((Date)item).getTime()).toLocalDate());
            }
        } else {
            text = FormatHelper.formatDateFast(item);
        }
        return text;
    }
}

