/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.text.DecimalFormat;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.type.AbstractTableCellType;

@TableCellTypeService(value=Number.class)
public class NumberTableCellType<T extends Number>
extends AbstractTableCellType<T> {
    @Override
    public void updateItem(FxTableCell<?, T> tableCell, T item) {
        tableCell.setGraphic(null);
        DecimalFormat fmt = this.getFormat(tableCell.getColumnConfiguration(), item);
        String text = fmt != null ? fmt.format(item) : item.toString();
        tableCell.setText(text);
        this.updateAlignment(tableCell, Pos.BASELINE_RIGHT);
    }

    @Override
    public void updateItem(FxTreeTableCell<?, T> treeTableCell, T item) {
        treeTableCell.setGraphic(null);
        DecimalFormat fmt = this.getFormat(treeTableCell.getColumnConfiguration(), item);
        String text = fmt != null ? fmt.format(item) : item.toString();
        treeTableCell.setText(text);
        this.updateAlignment(treeTableCell, Pos.BASELINE_RIGHT);
    }

    protected DecimalFormat getFormat(TableColumnConfiguration<?, T> config, T item) {
        return config.getNumberFormat();
    }
}

