/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTreeTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractDateTimeTableCellType;
import org.tentackle.misc.FormatHelper;

@TableCellTypeService(value=ZonedDateTime.class)
public class ZonedDateTimeTableCellType
extends AbstractDateTimeTableCellType<ZonedDateTime> {
    @Override
    public void updateItem(FxTableCell<?, ZonedDateTime> tableCell, ZonedDateTime item) {
        tableCell.setGraphic(null);
        tableCell.setText(this.formatItem(this.getFormatter(tableCell.getColumnConfiguration()), item));
        this.updateAlignment(tableCell, Pos.BASELINE_LEFT);
    }

    @Override
    public void updateItem(FxTreeTableCell<?, ZonedDateTime> treeTableCell, ZonedDateTime item) {
        treeTableCell.setGraphic(null);
        treeTableCell.setText(this.formatItem(this.getFormatter(treeTableCell.getColumnConfiguration()), item));
        this.updateAlignment(treeTableCell, Pos.BASELINE_LEFT);
    }

    @Override
    protected String formatItem(DateTimeFormatter fmt, ZonedDateTime item) {
        if (fmt == null) {
            fmt = FormatHelper.getZonedDateTimeFormatter();
        }
        return fmt.format(item);
    }
}

