/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.function.Function;
import org.tentackle.common.BMoney;
import org.tentackle.common.DMoney;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.FractionNumberStringTranslator;
import org.tentackle.misc.FormatHelper;

@ValueTranslatorService(modelClass=BMoney.class, viewClass=String.class)
public class BMoneyStringTranslator
extends FractionNumberStringTranslator<BMoney> {
    public BMoneyStringTranslator(FxTextComponent component) {
        super(component);
    }

    @Override
    public Function<BMoney, String> toViewFunction() {
        return v -> v == null ? null : this.getFormat().format(v);
    }

    @Override
    public Function<String, BMoney> toModelFunction() {
        return this::parse;
    }

    @Override
    public String getDefaultPattern() {
        return FormatHelper.getMoneyPattern();
    }

    protected BMoney parse(String str) {
        if (str != null) {
            DecimalFormat decimalFormat = this.getFormat();
            char commaChar = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
            boolean parseDMoney = DMoney.class.isAssignableFrom(this.getComponent().getType());
            if (this.getComponent().getScale() > 0 && ((String)str).indexOf(commaChar) < 0 && FxUtilities.getInstance().isLenientMoneyInput(this.getComponent())) {
                int len;
                int prec = this.getComponent().getScale();
                for (len = ((String)str).length(); len <= prec; ++len) {
                    str = "0" + (String)str;
                }
                str = ((String)str).substring(0, len - prec) + commaChar + ((String)str).substring(len - prec);
            }
            try {
                decimalFormat.setParseBigDecimal(true);
                BigDecimal value = (BigDecimal)decimalFormat.parse((String)str);
                value = value.setScale(this.getComponent().getScale(), RoundingMode.HALF_UP);
                DMoney money = null;
                if (parseDMoney) {
                    if (value.precision() > 19) {
                        this.getComponent().setError(MessageFormat.format(FxFxBundle.getString("MONEY VALUE MUST NOT EXCEED {0} DIGITS"), 19));
                        this.getComponent().setErrorTemporary(true);
                    } else {
                        money = new DMoney(value);
                    }
                } else if (value.precision() > 15) {
                    this.getComponent().setError(MessageFormat.format(FxFxBundle.getString("MONEY VALUE MUST NOT EXCEED {0} DIGITS"), 15));
                    this.getComponent().setErrorTemporary(true);
                } else {
                    money = new BMoney(value);
                }
                return money;
            }
            catch (ParseException e) {
                this.getComponent().setErrorOffset(e.getErrorOffset());
                this.getComponent().setError(MessageFormat.format(FxFxBundle.getString("INVALID MONEY VALUE: {0}"), str));
                this.getComponent().setErrorTemporary(true);
            }
        }
        return null;
    }
}

