/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderFactory;
import org.tentackle.fx.translate.AbstractValueTranslator;
import org.tentackle.reflect.ReflectionHelper;

@ValueTranslatorService(modelClass=Collection.class, viewClass=TreeItem.class)
public class CollectionTreeItemTranslator<T, C extends Collection<T>>
extends AbstractValueTranslator<C, TreeItem<T>> {
    private boolean providerLoaded;
    private TableConfigurationProvider<T> provider;
    private boolean configurationLoaded;
    private TableConfiguration<T> configuration;
    private C collection;

    public CollectionTreeItemTranslator(FxComponent component) {
        super(component);
        this.configureComponent();
    }

    @Override
    public Function<C, TreeItem<T>> toViewFunction() {
        return m -> {
            this.collection = m;
            TreeItem root = new TreeItem();
            if (m != null) {
                for (Object elem : m) {
                    root.getChildren().add(this.createTreeItem(elem));
                }
            }
            return root;
        };
    }

    @Override
    public Function<TreeItem<T>, C> toModelFunction() {
        return v -> {
            if (this.collection != null) {
                this.collection.clear();
                Object root = this.getComponent() instanceof FxTreeView ? ((FxTreeView)this.getComponent()).getRoot() : (this.getComponent() instanceof FxTreeTableView ? ((FxTreeTableView)this.getComponent()).getRoot() : null);
                if (root != null) {
                    for (TreeItem treeItem : root.getChildren()) {
                        this.collection.add((Object)treeItem.getValue());
                    }
                }
            }
            return this.collection;
        };
    }

    protected void configureComponent() {
        FxComponent component = this.getComponent();
        Class elemClass = ReflectionHelper.extractGenericInnerTypeClass((Type)component.getGenericType());
        if (elemClass != null) {
            if (component instanceof FxTreeView) {
                FxTreeView treeView = (FxTreeView)component;
                treeView.setShowRoot(false);
            } else if (component instanceof FxTreeTableView) {
                FxTreeTableView treeTableView = (FxTreeTableView)component;
                treeTableView.setShowRoot(false);
                this.configureTreeTableView(treeTableView, this.getTableConfiguration());
            }
        }
    }

    protected TableConfigurationProvider<T> getTableConfigurationProvider() {
        if (!this.providerLoaded) {
            Class elemClass = ReflectionHelper.extractGenericInnerTypeClass((Type)this.getComponent().getGenericType());
            if (elemClass != null) {
                this.provider = TableConfigurationProviderFactory.getInstance().createTableConfigurationProvider(elemClass);
                if (this.provider != null) {
                    this.configuration = this.provider.createTableConfiguration();
                }
            }
            this.providerLoaded = true;
        }
        return this.provider;
    }

    protected TableConfiguration<T> getTableConfiguration() {
        if (!this.configurationLoaded) {
            TableConfigurationProvider<T> provider = this.getTableConfigurationProvider();
            if (provider != null) {
                this.configuration = provider.createTableConfiguration();
            }
            this.configurationLoaded = true;
        }
        return this.configuration;
    }

    protected TreeItem<T> createTreeItem(Object object) {
        TableConfiguration<T> configuration = this.getTableConfiguration();
        return configuration != null ? configuration.createTreeItem(object) : new TreeItem(object);
    }

    protected void configureTreeTableView(FxTreeTableView<T> treeTableView, TableConfiguration<T> configuration) {
        if (configuration != null) {
            configuration.configure(treeTableView);
            if (configuration.getBindingType() == TableConfiguration.BINDING.YES) {
                configuration.getBinder().bind();
            } else if (configuration.getBindingType() == TableConfiguration.BINDING.INHERITED) {
                configuration.getBinder().bindAllInherited();
            }
        }
    }
}

