/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.time.LocalDate;
import java.util.function.Function;
import org.tentackle.common.Date;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.LocalDateStringTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=java.util.Date.class, viewClass=String.class)
public class DateStringTranslator
extends ValueStringTranslator<java.util.Date> {
    private final LocalDateStringTranslator translator;

    public DateStringTranslator(FxTextComponent component) {
        super(component);
        this.translator = new LocalDateStringTranslator(component);
    }

    @Override
    public Function<java.util.Date, String> toViewFunction() {
        return v -> this.translator.format(v == null ? null : this.toSqlDate((java.util.Date)v).toLocalDate());
    }

    @Override
    public Function<String, java.util.Date> toModelFunction() {
        return s -> {
            LocalDate localdate = (LocalDate)this.translator.parse((String)s);
            if (localdate == null) {
                return null;
            }
            java.sql.Date sqlDate = java.sql.Date.valueOf(localdate);
            if (java.sql.Date.class == this.getComponent().getType()) {
                return sqlDate;
            }
            if (java.util.Date.class == this.getComponent().getType()) {
                return new java.util.Date(sqlDate.getTime());
            }
            return new Date(sqlDate.getTime());
        };
    }

    private java.sql.Date toSqlDate(java.util.Date date) {
        return date instanceof java.sql.Date ? (java.sql.Date)date : new java.sql.Date(date.getTime());
    }
}

