/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.common.I18NText;
import org.tentackle.common.LocaleProvider;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.translate.I18NTextStringTranslator;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class I18NEditor
extends AbstractFxController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private Label headerLabel;
    @FXML
    private VBox translationsPane;
    @FXML
    private Button applyButton;
    @FXML
    private Button discardButton;
    private I18NText i18NText;
    private I18NTextStringTranslator i18NTextStringTranslator;
    private Control component;
    private Map<Locale, TextInputControl> editorMap;

    public static void showDialog(I18NText i18NText, I18NTextStringTranslator i18NTextStringTranslator) {
        I18NEditor i18NEditor = Fx.load(I18NEditor.class);
        i18NEditor.setI18NText(i18NText, i18NTextStringTranslator);
        Stage stage = Fx.createStage(Modality.WINDOW_MODAL);
        Scene scene = Fx.createScene(i18NEditor.getView());
        stage.initOwner((Window)Fx.getStage((Node)i18NEditor.component));
        stage.setTitle(i18NEditor.resources.getString("translations"));
        stage.setScene(scene);
        stage.show();
    }

    @FXML
    private void initialize() {
        this.applyButton.setOnAction(event -> this.apply());
        this.discardButton.setOnAction(event -> this.close());
    }

    private void setI18NText(I18NText i18NText, I18NTextStringTranslator i18NTextStringTranslator) {
        this.i18NText = Objects.requireNonNull(i18NText);
        this.i18NTextStringTranslator = Objects.requireNonNull(i18NTextStringTranslator);
        this.component = (Control)i18NTextStringTranslator.getComponent();
        double width = this.component.getWidth();
        double height = this.component.getHeight();
        Control control = this.component;
        if (control instanceof FxTextComponent) {
            FxTextComponent textComponent = (FxTextComponent)control;
            this.headerLabel.setText(textComponent.getBinding().getMember().getMemberName());
        }
        Locale fallbackLocale = LocaleProvider.getInstance().getFallbackLocale();
        LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
        for (Locale effectiveLocale : LocaleProvider.getInstance().getEffectiveLocales()) {
            locales.add(new Locale(effectiveLocale.getLanguage()));
        }
        this.editorMap = new LinkedHashMap<Locale, TextInputControl>();
        TreeMap<String, VBox> vBoxMap = new TreeMap<String, VBox>();
        for (Locale locale : locales) {
            TextInputControl editor = this.component instanceof TextArea ? (TextInputControl)Fx.create(TextArea.class) : (TextInputControl)Fx.create(TextField.class);
            editor.setPrefWidth(width);
            editor.setPrefHeight(height);
            this.editorMap.put(locale, editor);
            VBox vBox = (VBox)Fx.create(VBox.class);
            vBox.setSpacing(5.0);
            vBox.setPadding(new Insets(5.0));
            Label languageLabel = (Label)Fx.create(Label.class);
            StringBuilder labelText = new StringBuilder();
            labelText.append(locale.getLanguage()).append(" = ").append(locale.getDisplayLanguage());
            boolean isFallback = fallbackLocale.getLanguage().equals(locale.getLanguage());
            boolean isCurrent = LocaleProvider.getInstance().getEffectiveLocale().getLanguage().equals(locale.getLanguage());
            if (isFallback || isCurrent) {
                labelText.append(" (");
                if (isFallback) {
                    labelText.append(this.resources.getString("default"));
                }
                if (isCurrent) {
                    if (isFallback) {
                        labelText.append(", ");
                    }
                    labelText.append(this.resources.getString("current"));
                }
                labelText.append(")");
            }
            languageLabel.setText(labelText.toString());
            vBox.getChildren().addAll((Object[])new Node[]{languageLabel, editor});
            vBoxMap.put(locale.getLanguage(), vBox);
        }
        this.translationsPane.getChildren().add((Object)((Node)vBoxMap.remove(fallbackLocale.getLanguage())));
        this.translationsPane.getChildren().addAll(vBoxMap.values());
        this.updateView();
    }

    private void updateView() {
        for (Map.Entry<Locale, TextInputControl> entry : this.editorMap.entrySet()) {
            entry.getValue().setText((String)this.i18NText.getTranslations().get(entry.getKey()));
        }
    }

    private void apply() {
        Map translations = this.i18NText.getTranslations();
        for (Map.Entry<Locale, TextInputControl> entry : this.editorMap.entrySet()) {
            Locale locale = entry.getKey();
            String newText = entry.getValue().getText();
            String oldText = (String)translations.get(locale);
            if (Objects.equals(oldText, newText)) continue;
            this.i18NText = this.i18NText.with(locale, newText);
        }
        this.i18NTextStringTranslator.updateI18NText(this.i18NText);
        this.close();
    }

    private void close() {
        Fx.getStage((Node)this.getView()).close();
    }
}

