/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.tentackle.common.I18NText;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.I18NEditor;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=I18NText.class, viewClass=String.class)
public class I18NTextStringTranslator
extends ValueStringTranslator<I18NText> {
    private static final String STYLE_I18N = "tt-i18n";
    private I18NText savedModelValue;

    public I18NTextStringTranslator(FxTextComponent component) {
        super(component);
        Control control = (Control)component;
        if (!control.getStyleClass().contains((Object)STYLE_I18N)) {
            ContextMenu menu;
            control.getStyleClass().add((Object)STYLE_I18N);
            control.addEventFilter(KeyEvent.ANY, event -> {
                if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || event.getCode() != KeyCode.F2)) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::edit);
                    }
                }
            });
            if (control.getContextMenu() == null) {
                menu = (ContextMenu)Fx.create(ContextMenu.class);
                control.setContextMenu(menu);
            } else {
                MenuItem separatorItem = (MenuItem)Fx.create(SeparatorMenuItem.class);
                menu = control.getContextMenu();
                menu.getItems().add((Object)separatorItem);
            }
            MenuItem editItem = (MenuItem)Fx.create(MenuItem.class);
            editItem.setText(FxFxBundle.getString("EDIT_I18N"));
            editItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
            editItem.setOnAction(event -> this.edit());
            menu.getItems().add((Object)editItem);
        }
    }

    @Override
    public boolean isMappingIncomplete() {
        return true;
    }

    @Override
    public void saveModelValue(I18NText modelValue) {
        this.savedModelValue = modelValue;
    }

    @Override
    public boolean isModelModified() {
        I18NText savedValue;
        I18NText modelValue = null;
        Object object = this.getComponent().getBinding().getModelValue();
        if (object instanceof I18NText) {
            I18NText i18NText = (I18NText)object;
            I18NText i18NText2 = modelValue = i18NText.isVacant() ? null : i18NText;
        }
        if ((savedValue = this.savedModelValue) != null && savedValue.isVacant()) {
            savedValue = null;
        }
        return !Objects.equals(savedValue, modelValue);
    }

    @Override
    public Function<I18NText, String> toViewFunction() {
        return v -> v == null ? null : v.get();
    }

    @Override
    public Function<String, I18NText> toModelFunction() {
        return s -> {
            Object modelValue = this.getComponent().getBinding().getModelValue();
            if (modelValue instanceof I18NText) {
                I18NText i18NText = (I18NText)modelValue;
                return Objects.equals(i18NText.get(), s) ? i18NText : i18NText.with(s);
            }
            return s == null ? null : new I18NText(s);
        };
    }

    public void updateI18NText(I18NText i18NText) {
        this.getComponent().getBinding().setModelValue(i18NText.isVacant() ? null : i18NText);
    }

    protected void edit() {
        I18NText i18NText;
        Object object = this.getComponent().getBinding().getModelValue();
        I18NEditor.showDialog(object instanceof I18NText ? (i18NText = (I18NText)object) : new I18NText(), this);
    }
}

