/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import org.tentackle.bind.BindingException;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.translate.ValueStringTranslator;
import org.tentackle.misc.DateTimeUtilities;
import org.tentackle.misc.ObjectUtilities;
import org.tentackle.misc.time.NumberShortcut;
import org.tentackle.misc.time.SmartDateTimeParser;

public abstract class TemporalStringTranslator<T extends Temporal>
extends ValueStringTranslator<T>
implements NumberShortcut.WindowProvider,
SmartDateTimeParser.Shortcut {
    public static final String REFERENCE_DATE_SUPPLIER = "referenceDateSupplier";
    public static final String YEAR_WINDOW = "yearWindow";
    public static final String MONTH_WINDOW = "monthWindow";
    public static final String DAY_WINDOW = "dayWindow";
    private List<SmartDateTimeParser.Shortcut> shortcuts;
    private NumberShortcut.WindowProvider defaultWindowProvider;
    private T lastValue;
    private SmartDateTimeParser<T> parser;

    public static void connectAsReferenceDateSuppliers(FxTextComponent a, FxTextComponent b) {
        FxComponentBinding bindingA = a.getBinding();
        FxComponentBinding bindingB = b.getBinding();
        if (bindingA == null || bindingB == null) {
            throw new BindingException("both components must be bound to the model");
        }
        ((Node)a).getProperties().put((Object)REFERENCE_DATE_SUPPLIER, () -> ((FxComponentBinding)bindingB).getModelValue());
        ((Node)b).getProperties().put((Object)REFERENCE_DATE_SUPPLIER, () -> ((FxComponentBinding)bindingA).getModelValue());
    }

    public TemporalStringTranslator(FxTextComponent component) {
        super(component);
    }

    @Override
    public Function<T, String> toViewFunction() {
        return this::format;
    }

    @Override
    public Function<String, T> toModelFunction() {
        return this::parse;
    }

    protected Supplier<?> getReferenceDateSupplier() {
        return (Supplier)((Node)this.getComponent()).getProperties().get((Object)REFERENCE_DATE_SUPPLIER);
    }

    public int getYearWindow() {
        Integer val = (Integer)((Node)this.getComponent()).getProperties().get((Object)YEAR_WINDOW);
        return val == null ? this.getDefaultYearWindow() : val.intValue();
    }

    protected int getDefaultYearWindow() {
        return this.defaultWindowProvider == null ? 50 : this.defaultWindowProvider.getYearWindow();
    }

    public int getMonthWindow() {
        Integer val = (Integer)((Node)this.getComponent()).getProperties().get((Object)MONTH_WINDOW);
        return val == null ? this.getDefaultMonthWindow() : val.intValue();
    }

    protected int getDefaultMonthWindow() {
        return this.defaultWindowProvider == null ? -1 : this.defaultWindowProvider.getMonthWindow();
    }

    public int getDayWindow() {
        Integer val = (Integer)((Node)this.getComponent()).getProperties().get((Object)DAY_WINDOW);
        return val == null ? this.getDefaultDayWindow() : val.intValue();
    }

    protected int getDefaultDayWindow() {
        return this.defaultWindowProvider == null ? -1 : this.defaultWindowProvider.getDayWindow();
    }

    public SmartDateTimeParser.TextRange test(SmartDateTimeParser<? extends Temporal> parser, String text) {
        char c;
        if (!text.isEmpty() && (c = text.charAt(0)) == '@') {
            return new SmartDateTimeParser.TextRange(0, 1);
        }
        return null;
    }

    public <V extends Temporal> V parse(SmartDateTimeParser<V> parser, V currentValue, String part) {
        Object refValue = null;
        Supplier<?> dateSupplier = this.getReferenceDateSupplier();
        if (dateSupplier != null) {
            refValue = dateSupplier.get();
        }
        return (V)((Temporal)ObjectUtilities.getInstance().convert(this.getParser().getType(), refValue));
    }

    public List<SmartDateTimeParser.Shortcut> getShortcuts() {
        if (this.shortcuts == null) {
            ArrayList<SmartDateTimeParser.Shortcut> scList = new ArrayList<SmartDateTimeParser.Shortcut>();
            scList.add(this);
            for (SmartDateTimeParser.Shortcut shortcut : DateTimeUtilities.getInstance().getShortcuts()) {
                if (shortcut instanceof NumberShortcut) {
                    this.defaultWindowProvider = ((NumberShortcut)shortcut).getWindowProvider();
                    shortcut = new NumberShortcut((NumberShortcut.WindowProvider)this);
                }
                scList.add(shortcut);
            }
            this.shortcuts = scList;
        }
        return this.shortcuts;
    }

    public List<SmartDateTimeParser.ErrorHandler> getHandlers() {
        return DateTimeUtilities.getInstance().getHandlers();
    }

    public List<SmartDateTimeParser.TextFilter> getFilters() {
        return DateTimeUtilities.getInstance().getFilters();
    }

    protected abstract SmartDateTimeParser<T> createParser();

    protected SmartDateTimeParser<T> getParser() {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    protected String format(T value) {
        this.lastValue = value;
        return this.getParser().format(value);
    }

    protected T getLastValue() {
        return this.lastValue;
    }

    protected T parse(String s) {
        try {
            return (T)this.getParser().parse(this::getLastValue, s);
        }
        catch (DateTimeException dtx) {
            String text;
            if (dtx instanceof DateTimeParseException) {
                DateTimeParseException px = (DateTimeParseException)dtx;
                this.getComponent().setErrorOffset(px.getErrorIndex());
                text = px.getParsedString();
            } else {
                text = s;
            }
            String msg = this.parser.isWithDate() ? (this.parser.isWithTime() ? FxFxBundle.getString("INVALID TIMESTAMP: {0}") : FxFxBundle.getString("INVALID DATE: {0}")) : FxFxBundle.getString("INVALID TIME: {0}");
            this.getComponent().setError(MessageFormat.format(msg, text));
            this.getComponent().setErrorTemporary(true);
            return null;
        }
    }
}

