/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.sql.Time;
import java.time.LocalTime;
import java.util.function.Function;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.LocalTimeStringTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=Time.class, viewClass=String.class)
public class TimeStringTranslator
extends ValueStringTranslator<Time> {
    private final LocalTimeStringTranslator translator;

    public TimeStringTranslator(FxTextComponent component) {
        super(component);
        this.translator = new LocalTimeStringTranslator(component);
    }

    @Override
    public Function<Time, String> toViewFunction() {
        return v -> this.translator.format(v == null ? null : v.toLocalTime());
    }

    @Override
    public Function<String, Time> toModelFunction() {
        return s -> {
            LocalTime localTime = (LocalTime)this.translator.parse((String)s);
            if (localTime == null) {
                return null;
            }
            Time sqlTime = Time.valueOf(localTime);
            if (Time.class == this.getComponent().getType()) {
                return sqlTime;
            }
            return new org.tentackle.common.Time(sqlTime.getTime());
        };
    }
}

