/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.function.Function;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.LocalDateTimeStringTranslator;
import org.tentackle.fx.translate.ValueStringTranslator;

@ValueTranslatorService(modelClass=Timestamp.class, viewClass=String.class)
public class TimestampStringTranslator
extends ValueStringTranslator<Timestamp> {
    private final LocalDateTimeStringTranslator translator;

    public TimestampStringTranslator(FxTextComponent component) {
        super(component);
        this.translator = new LocalDateTimeStringTranslator(component);
    }

    @Override
    public Function<Timestamp, String> toViewFunction() {
        return v -> this.translator.format(v == null ? null : v.toLocalDateTime());
    }

    @Override
    public Function<String, Timestamp> toModelFunction() {
        return s -> {
            LocalDateTime localDateTime = (LocalDateTime)this.translator.parse((String)s);
            if (localDateTime == null) {
                return null;
            }
            Timestamp sqlTimestamp = Timestamp.valueOf(localDateTime);
            if (Timestamp.class == this.getComponent().getType()) {
                return sqlTimestamp;
            }
            return new org.tentackle.common.Timestamp(sqlTimestamp.getTime());
        };
    }
}

