/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.util.function.Function;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTreeTableView;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderFactory;
import org.tentackle.fx.translate.AbstractValueTranslator;

@ValueTranslatorService(modelClass=Object.class, viewClass=TreeItem.class)
public class TreeItemTranslator<T>
extends AbstractValueTranslator<T, TreeItem<T>> {
    private boolean providerLoaded;
    private TableConfigurationProvider<T> provider;
    private boolean configurationLoaded;
    private TableConfiguration<T> configuration;

    public TreeItemTranslator(FxComponent component) {
        super(component);
        this.configureComponent();
    }

    @Override
    public Function<T, TreeItem<T>> toViewFunction() {
        return this::createTreeItem;
    }

    @Override
    public Function<TreeItem<T>, T> toModelFunction() {
        return TreeItem::getValue;
    }

    protected void configureComponent() {
        FxComponent component = this.getComponent();
        if (component instanceof FxTreeView) {
            FxTreeView fxTreeView = (FxTreeView)component;
        } else if (component instanceof FxTreeTableView) {
            FxTreeTableView treeTableView = (FxTreeTableView)component;
            this.configureTreeTableView(treeTableView, this.getTableConfiguration());
        }
    }

    protected TableConfigurationProvider<T> getTableConfigurationProvider() {
        if (!this.providerLoaded) {
            Class<?> elemClass = this.getComponent().getType();
            if (elemClass != null) {
                this.provider = TableConfigurationProviderFactory.getInstance().createTableConfigurationProvider(elemClass);
                if (this.provider != null) {
                    this.configuration = this.provider.createTableConfiguration();
                }
            }
            this.providerLoaded = true;
        }
        return this.provider;
    }

    protected TableConfiguration<T> getTableConfiguration() {
        if (!this.configurationLoaded) {
            TableConfigurationProvider<T> provider = this.getTableConfigurationProvider();
            if (provider != null) {
                this.configuration = provider.createTableConfiguration();
            }
            this.configurationLoaded = true;
        }
        return this.configuration;
    }

    protected TreeItem<T> createTreeItem(T object) {
        TableConfiguration<T> configuration = this.getTableConfiguration();
        return configuration != null ? configuration.createTreeItem(object) : new TreeItem(object);
    }

    protected void configureTreeTableView(FxTreeTableView<T> treeTableView, TableConfiguration<T> configuration) {
        if (configuration != null) {
            configuration.configure(treeTableView);
            if (configuration.getBindingType() == TableConfiguration.BINDING.YES) {
                configuration.getBinder().bind();
            } else if (configuration.getBindingType() == TableConfiguration.BINDING.INHERITED) {
                configuration.getBinder().bindAllInherited();
            }
        }
    }
}

