/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.i18n;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.tentackle.common.BundleFactory;
import org.tentackle.i18n.StoredResourceBundle;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoListener;
import org.tentackle.session.ModificationEvent;
import org.tentackle.session.ModificationListener;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;

public class StoredBundleControl
extends ResourceBundle.Control
implements DomainContextProvider {
    private static boolean fallbackToProperties = true;
    private static final Logger LOGGER = Logger.get(StoredBundleControl.class);
    private static final List<String> FORMATS = Collections.singletonList("");
    private static boolean listenerRegistered;
    private DomainContext context;

    public static boolean isFallbackToProperties() {
        return fallbackToProperties;
    }

    public static void setFallbackToProperties(boolean fallbackToProperties) {
        StoredBundleControl.fallbackToProperties = fallbackToProperties;
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    @Override
    public List<String> getFormats(String baseName) {
        if (Session.getCurrentSession() == null) {
            return super.getFormats(baseName);
        }
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMATS;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (baseName == null || locale == null) {
            throw new IllegalArgumentException("baseName and locale must not be null");
        }
        ResourceBundle bundle = null;
        StoredBundle.StoredBundleUDK key = null;
        if (Session.getCurrentSession() != null) {
            key = this.createUDK(baseName, locale);
            bundle = this.loadStoredBundle(key);
        }
        if (bundle == null && fallbackToProperties) {
            if (format == null || loader == null) {
                throw new IllegalArgumentException("format and loader must not be null");
            }
            if (format.isEmpty()) {
                format = "java.properties";
            }
            if ((bundle = super.newBundle(baseName, locale, format, loader, reload)) != null && key != null) {
                LOGGER.info("no stored bundle for {0} -> resource bundle from properties loaded instead", new Object[]{key.name});
            }
        }
        return bundle;
    }

    protected StoredBundle.StoredBundleUDK createUDK(String baseName, Locale locale) {
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "").replace('/', '.');
        String name = resourceName.endsWith(".") ? resourceName.substring(0, resourceName.length() - 1) : resourceName;
        String loc = null;
        int ndx = name.indexOf(95);
        if (ndx >= 0) {
            loc = name.substring(ndx + 1);
            name = name.substring(0, ndx);
        }
        return new StoredBundle.StoredBundleUDK(name, loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredResourceBundle loadStoredBundle(StoredBundle.StoredBundleUDK key) {
        StoredBundle bundle;
        StoredBundleControl storedBundleControl = this;
        synchronized (storedBundleControl) {
            if (this.context == null && Session.getCurrentSession() != null) {
                this.context = Pdo.createDomainContext();
                if (!listenerRegistered) {
                    ModificationTracker.getInstance().addModificationListener((ModificationListener)new PdoListener(new Class[]{StoredBundle.class}){

                        public void dataChanged(ModificationEvent ev) {
                            BundleFactory.getInstance().clearCache();
                        }
                    });
                    listenerRegistered = true;
                    LOGGER.info("bundle factory modification listener registered");
                }
            }
        }
        if (this.context != null && Session.getCurrentSession() != null && (bundle = ((StoredBundle)this.on(StoredBundle.class)).selectCachedByUniqueDomainKey(key)) != null) {
            LOGGER.info("stored bundle {0} loaded", new Object[]{bundle});
            return new StoredResourceBundle(bundle);
        }
        return null;
    }
}

